/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.wechat.service.impl;

import com.wmeimob.fastboot.starter.wechat.dto.WechatJsPayDTO;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.starter.wechat.service.WepayService;
import com.wmeimob.fastboot.util.web.IpAddressHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.model.pay.JsPayRequest;
import me.hao0.wepay.model.pay.JsPayResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="wepayService")
public class WepayServiceImpl
implements WepayService {
    private static final Logger log = LoggerFactory.getLogger(WepayServiceImpl.class);
    @Resource
    private WechatService wechatService;
    private static final BigDecimal TEST_TOTAL_FEE = new BigDecimal("0.05");

    @Override
    public JsPayResponse prePay(WechatJsPayDTO wechatJsPayDTO) {
        if (wechatJsPayDTO.getIsTest() != null && wechatJsPayDTO.getIsTest().booleanValue()) {
            wechatJsPayDTO.setTotalFee(TEST_TOTAL_FEE);
        }
        WechatMp wechatMp = this.wechatService.getWechatMp(wechatJsPayDTO.getAppid());
        Wepay wepay = this.wechatService.getWepay(wechatMp, this.wechatService.getWechatMch(wechatMp.getMchId()));
        JsPayRequest jsPayRequest = new JsPayRequest();
        jsPayRequest.setBody(wechatJsPayDTO.getBody());
        jsPayRequest.setOutTradeNo(wechatJsPayDTO.getOrderNo());
        jsPayRequest.setTotalFee(Integer.valueOf(wechatJsPayDTO.getTotalFee().multiply(new BigDecimal("100")).intValue()));
        jsPayRequest.setOpenId(wechatJsPayDTO.getOpenid());
        jsPayRequest.setClientIp(IpAddressHelper.getRemoteHost((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()));
        jsPayRequest.setNotifyUrl(wechatJsPayDTO.getNotifyUrl());
        jsPayRequest.setTimeStart(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        return wepay.pay().jsPay(jsPayRequest);
    }

    @Override
    public void closeOrders(String appid, String ordersNo) {
        WechatMp wechatMp = this.wechatService.getWechatMp(appid);
        Wepay wepay = this.wechatService.getWepay(wechatMp, this.wechatService.getWechatMch(wechatMp.getMchId()));
        boolean closeOrderResult = wepay.order().closeOrder(ordersNo);
        if (!closeOrderResult) {
            throw new RuntimeException(String.format("close order %s failure,cause it return null !", ordersNo));
        }
    }
}

