/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.wechat.loader;

import java.util.concurrent.TimeUnit;
import me.hao0.wechat.loader.TicketLoader;
import me.hao0.wechat.model.js.Ticket;
import me.hao0.wechat.model.js.TicketType;
import org.springframework.data.redis.core.StringRedisTemplate;

public class WechatTicketLoader
implements TicketLoader {
    private String appid;
    private StringRedisTemplate redisTemplate;

    private WechatTicketLoader() {
    }

    public WechatTicketLoader(String appid, StringRedisTemplate redisTemplate) {
        this.appid = appid;
        this.redisTemplate = redisTemplate;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String get(TicketType type) {
        return (String)this.redisTemplate.opsForValue().get((Object)("mps:appid:" + this.appid + ":ticket:" + type.type()));
    }

    public void refresh(Ticket ticket) {
        this.redisTemplate.opsForValue().set((Object)("mps:appid:" + this.appid + ":ticket:" + ticket.getType().type()), (Object)ticket.getTicket(), (long)ticket.getExpire().intValue() - 600L, TimeUnit.SECONDS);
    }
}

