/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.wechat.loader;

import java.util.concurrent.TimeUnit;
import me.hao0.wechat.loader.AccessTokenLoader;
import me.hao0.wechat.model.base.AccessToken;
import org.springframework.data.redis.core.StringRedisTemplate;

public class WechatMpAccessTokenLoader
implements AccessTokenLoader {
    private String appid;
    private StringRedisTemplate redisTemplate;

    private WechatMpAccessTokenLoader() {
    }

    public WechatMpAccessTokenLoader(String appid, StringRedisTemplate redisTemplate) {
        this.appid = appid;
        this.redisTemplate = redisTemplate;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String get() {
        return (String)this.redisTemplate.opsForValue().get((Object)("mps:" + this.appid + ":access_token"));
    }

    public void refresh(AccessToken token) {
        this.redisTemplate.opsForValue().set((Object)("mps:" + this.appid + ":access_token"), (Object)token.getAccessToken(), (long)token.getExpire().intValue() - 600L, TimeUnit.SECONDS);
    }
}

