/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.schedule;

import com.wmeimob.fastboot.bizvane.service.CommentsService;
import com.wmeimob.fastboot.bizvane.service.CommonIntegralGoodsService;
import com.wmeimob.fastboot.bizvane.service.CommonIntegralOrdersService;
import com.wmeimob.fastboot.bizvane.service.MiniprogramReleaseService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.open.entity.MiniprogramRelease;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class UserCommissionSchedule {
    private static final Logger log = LoggerFactory.getLogger(UserCommissionSchedule.class);
    @Resource(name="commonUserCommissionService")
    private UserCommissionService userCommissionService;
    @Resource(name="commentsCommissionService")
    private CommentsService commentsService;
    @Resource
    private MiniprogramReleaseService miniprogramReleaseService;
    @Resource
    private CommonIntegralGoodsService commonIntegralGoodsService;
    @Resource
    private CommonIntegralOrdersService commonIntegralOrdersService;

    @Scheduled(fixedDelay=120000L)
    public void commissionSettle() {
        log.info("commissionSettle schedule start...");
        List byCondition = this.miniprogramReleaseService.findByCondition((Serializable)new MiniprogramRelease());
        for (MiniprogramRelease release : byCondition) {
            this.userCommissionService.settle(release.getMerchantId());
        }
    }

    @Scheduled(fixedDelay=120000L)
    public void commentsSettle() {
        log.info("commentsSettle schedule start...");
        List byCondition = this.miniprogramReleaseService.findByCondition((Serializable)new MiniprogramRelease());
        for (MiniprogramRelease release : byCondition) {
            this.commentsService.settle(release.getMerchantId());
        }
    }

    @Scheduled(fixedDelay=120000L)
    public void automaticUpperShelf() {
        log.info("automaticUpperShelf schedule start...");
        List merchantIds = this.commonIntegralOrdersService.getAllMerchantId();
        for (Integer id : merchantIds) {
            this.commonIntegralGoodsService.getNotShelves(id);
        }
    }

    @Scheduled(cron="0 0 0/1 ? * *")
    public void integralAutoOrdersStatus() {
        log.info("integralAutoOrdersStatus schedule start...");
        List merchantIds = this.commonIntegralOrdersService.getAllMerchantId();
        for (Integer id : merchantIds) {
            this.commonIntegralOrdersService.settle(id);
        }
    }
}

