/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.AnalysisQuerySkuRes;
import com.wmeimob.fastboot.bizvane.dto.ReducePriceAnalysisRes;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReducePriceAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(ReducePriceAnalysisService.class);
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private MarketActivityMapper marketActivityMapper;
    public static String REDIS_FREEZE_STOCK_KEY = "wx_reducePrice_freeze_stock_";

    public PageInfo<AnalysisQuerySkuRes> queryActivityGoodAnalysis(MarketActivityGoods marketActivityGoods, String orderBySign, String pageNum, String pageSize) {
        PageHelper.startPage((int)Integer.parseInt(pageNum), (int)Integer.parseInt(pageSize));
        List goodsDetail = this.marketActivityGoodsMapper.getGoodsDetail(marketActivityGoods.getMarketActivityNo(), marketActivityGoods.getSkuNo(), marketActivityGoods.getGoodsNo(), null, marketActivityGoods.getGoodsName());
        if (CollectionUtils.isEmpty((Collection)goodsDetail)) {
            return null;
        }
        PageInfo pageInfo = new PageInfo(goodsDetail);
        return this.getAvailableAndConvertResult(pageInfo, orderBySign);
    }

    private PageInfo<AnalysisQuerySkuRes> getAvailableAndConvertResult(PageInfo<MarketActivityGoods> pageInfo, String orderBySign) {
        List list = pageInfo.getList();
        list = this.getAvailaleStock(list);
        return this.convertResult(list, pageInfo, orderBySign);
    }

    private PageInfo<AnalysisQuerySkuRes> convertResult(List<MarketActivityGoods> list, PageInfo<MarketActivityGoods> pageInfo, String orderBySign) {
        List aqslist = list.stream().map(e -> {
            AnalysisQuerySkuRes aqs = new AnalysisQuerySkuRes();
            BeanUtils.copyProperties((Object)e, (Object)aqs);
            aqs.setAvailableStock(e.getStock());
            return aqs;
        }).collect(Collectors.toList());
        Stream<AnalysisQuerySkuRes> sorted = null;
        sorted = "desc".equals(orderBySign) ? aqslist.stream().sorted(Comparator.comparing(AnalysisQuerySkuRes::getAvailableStock).reversed()) : aqslist.stream().sorted(Comparator.comparing(AnalysisQuerySkuRes::getAvailableStock));
        List collect = sorted.collect(Collectors.toList());
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)result);
        result.setList(collect);
        return result;
    }

    private List<MarketActivityGoods> getAvailaleStock(List<MarketActivityGoods> list) {
        list.stream().forEach(e -> e.setStock(Integer.valueOf(1)));
        return list;
    }

    public Map<String, Object> queryAnalysisResult(String activityNo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MarketActivityGoods marketActivityGoods = new MarketActivityGoods();
        marketActivityGoods.setMarketActivityNo(activityNo);
        PageInfo pageInfo = this.queryActivityGoodAnalysis(marketActivityGoods, "desc", "0", "20");
        result.put("pageResult", pageInfo);
        ReducePriceAnalysisRes res = this.analysisActivity(activityNo);
        result.put("analysisResult", res);
        return result;
    }

    private ReducePriceAnalysisRes analysisActivity(String activityNo) {
        MarketActivity ma = new MarketActivity();
        ma.setActivityNo(activityNo);
        ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
        ReducePriceAnalysisRes sum = this.marketActivityGoodsMapper.selectSumInfo(activityNo);
        ReducePriceAnalysisRes bp = this.marketActivityGoodsMapper.selectAboutBarginAndOrders(activityNo);
        ReducePriceAnalysisRes bms = this.marketActivityGoodsMapper.selectCountBargainOrders(activityNo);
        ReducePriceAnalysisRes processingOrders = this.marketActivityGoodsMapper.selectCountProcessingOrders(activityNo);
        BeanUtils.copyProperties((Object)ma, (Object)bms);
        bms.setCompleteDealNum(Integer.valueOf(sum.getCompleteDealNum() == null ? 0 : sum.getCompleteDealNum()));
        bms.setCompleteDealAmount(sum.getCompleteDealAmount() == null ? BigDecimal.ZERO : sum.getCompleteDealAmount());
        bms.setCompleteReduceAmount(bp.getCompleteReduceAmount() == null ? BigDecimal.ZERO : bp.getCompleteReduceAmount());
        int players = bp.getPlayers() == null ? 0 : bp.getPlayers();
        int i = bms.getInitiator() == null ? 0 : bms.getInitiator();
        bms.setPlayers(Integer.valueOf(players + i));
        Date beginTime = ma.getActivityBeginTime();
        Date eEndTime = ma.getActivityEndTime();
        bms.setStartTime(beginTime.getTime() + "");
        bms.setEndTime(eEndTime.getTime() + "");
        bms.setActivityName(ma.getActivityName());
        Date current = new Date();
        bms.setProcessingOrdersNum(processingOrders.getProcessingOrdersNum());
        if (current.before(beginTime)) {
            bms.setSign("\u672a\u5f00\u59cb");
            return null;
        }
        if (current.before(eEndTime)) {
            bms.setSign("\u8fdb\u884c\u4e2d");
        } else {
            bms.setSign("\u7ed3\u675f");
        }
        if (!ma.getActivityStatus().booleanValue()) {
            bms.setSign("\u7981\u7528");
        }
        return bms;
    }
}

