/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.open.entity.MiniprogramRelease;
import com.wmeimob.fastboot.open.enums.AuditStatusEnum;
import com.wmeimob.fastboot.open.mapper.MiniprogramReleaseMapper;
import com.wmeimob.fastboot.open.service.MiniprogramService;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.util.ResourcesFileReader;
import com.wmeimob.wechat.open.core.Wechat3rdPlatformHandler;
import com.wmeimob.wechat.open.core.miniprogram.Miniprogram;
import com.wmeimob.wechat.open.core.miniprogram.model.AuditStatusResponse;
import com.wmeimob.wechat.open.core.miniprogram.model.CategoryForVerifyResponse;
import com.wmeimob.wechat.open.core.miniprogram.model.CommitCodeRequest;
import com.wmeimob.wechat.open.core.miniprogram.model.SubmitAuditRequest;
import com.wmeimob.wechat.open.model.MiniProgramDomainSettings;
import com.wmeimob.wechat.open.model.Wechat3rdPlatform;
import com.wmeimob.wechat.service.WechatMpService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.model.base.WechatMp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import tk.mybatis.mapper.entity.Example;

@Service
public class MiniprogramServiceImpl
implements MiniprogramService {
    private static final Logger log = LoggerFactory.getLogger(MiniprogramServiceImpl.class);
    @Resource
    private WechatService wechatService;
    @Resource
    private MiniprogramReleaseMapper miniprogramReleaseMapper;
    @Resource
    private Wechat3rdPlatformHandler wechat3rdPlatformHandler;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private WechatMpService wechatMpService;
    @Resource
    private BizvaneInterface bizvaneInterface;

    public String testQrCode(MiniprogramRelease release) {
        WechatMp wechatMp = this.wechatService.getWechatMp((Object)release.getMpid());
        Miniprogram miniprogram = this.wechat3rdPlatformHandler.miniprogram(wechatMp.getAppid());
        Wechat3rdPlatform wechat3rdPlatform = this.wechat3rdPlatformHandler.getWechat3rdPlatform();
        this.setDomain(wechatMp.getAppid(), wechat3rdPlatform);
        this.commitCode(release, wechatMp);
        byte[] testQrcodeImage = miniprogram.code.getTestQrcodeImage(null);
        return Base64.getEncoder().encodeToString(testQrcodeImage);
    }

    public void oneKeySubmit(MiniprogramRelease release) {
        WechatMp wechatMp = this.wechatService.getWechatMp((Object)release.getMpid());
        Wechat3rdPlatform wechat3rdPlatform = this.wechat3rdPlatformHandler.getWechat3rdPlatform();
        this.setDomain(wechatMp.getAppid(), wechat3rdPlatform);
        this.commitCode(release, wechatMp);
        Integer audit = this.submitAudit(release, wechatMp);
        this.stringRedisTemplate.opsForValue().set((Object)("opens:authorizer_appids:" + wechatMp.getAppid() + ":audit"), (Object)(audit + ""));
    }

    public String queryAuditResult(Integer mpid) {
        WechatMp wechatMp = this.wechatService.getWechatMp((Object)mpid);
        Miniprogram miniprogram = this.wechat3rdPlatformHandler.miniprogram(wechatMp.getAppid());
        AuditStatusResponse result = miniprogram.code.getLatestAuditStatus();
        MiniprogramRelease miniRelease = new MiniprogramRelease();
        miniRelease.setMpid(mpid);
        miniRelease.setAuditStatus(Integer.valueOf(result.getStatus()));
        miniRelease.setFailReason(result.getReason());
        if (result.getStatus() == AuditStatusEnum.SUCCESS.status()) {
            miniRelease.setIsPublish(Boolean.valueOf(false));
        }
        this.update(miniRelease);
        return result.getReason();
    }

    public int update(MiniprogramRelease miniRelease) {
        Example example = new Example(MiniprogramRelease.class);
        example.createCriteria().andEqualTo("mpid", (Object)miniRelease.getMpid());
        miniRelease.setGmtModified(new Date());
        return this.miniprogramReleaseMapper.updateByExampleSelective((Object)miniRelease, (Object)example);
    }

    public void publish(Integer mpid) {
        WechatMp wechatMp = this.wechatService.getWechatMp((Object)mpid);
        Miniprogram miniprogram = this.wechat3rdPlatformHandler.miniprogram(wechatMp.getAppid());
        try {
            miniprogram.code.release();
            MiniprogramRelease release = new MiniprogramRelease();
            release.setMpid(mpid);
            MiniprogramRelease currentRelease = (MiniprogramRelease)this.miniprogramReleaseMapper.selectOne((Object)release);
            release.setIsPublish(Boolean.valueOf(true));
            release.setCurrentVersion(currentRelease.getAuditVersion());
            this.update(release);
        }
        catch (WechatException e) {
            log.error(e.getMessage());
            throw new CustomException("[" + e.getCode() + "]\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u53d1\u5e03");
        }
    }

    private MiniprogramRelease getMiniprogramReleaseByMpid(Integer mpid) {
        MiniprogramRelease release = new MiniprogramRelease();
        release.setMpid(mpid);
        MiniprogramRelease currentRelease = (MiniprogramRelease)this.miniprogramReleaseMapper.selectOne((Object)release);
        Assert.notNull((Object)currentRelease, (String)("mpid " + mpid + " cannot find release record "));
        return currentRelease;
    }

    private Integer submitAudit(MiniprogramRelease release, WechatMp wechatMp) {
        Miniprogram miniprogram = this.wechat3rdPlatformHandler.miniprogram(wechatMp.getAppid());
        CategoryForVerifyResponse categoryForVerify = miniprogram.code.getCategoryForVerify();
        log.info("\u7c7b\u76ee\u83b7\u53d6 =>{}", (Object)categoryForVerify);
        List pageList = miniprogram.code.getPageList();
        ArrayList<SubmitAuditRequest.ItemList> itemLists = new ArrayList<SubmitAuditRequest.ItemList>();
        Iterator iterator = pageList.iterator();
        if (iterator.hasNext()) {
            String s = (String)iterator.next();
            itemLists.add(SubmitAuditRequest.ItemList.builder().address(s).tag("\u5b66\u4e60 \u5de5\u4f5c").first_id(Integer.valueOf(((CategoryForVerifyResponse.CategoryList)categoryForVerify.getCategory_list().get(0)).getFirst_id())).first_class(((CategoryForVerifyResponse.CategoryList)categoryForVerify.getCategory_list().get(0)).getFirst_class()).second_id(Integer.valueOf(((CategoryForVerifyResponse.CategoryList)categoryForVerify.getCategory_list().get(0)).getSecond_id())).second_class(((CategoryForVerifyResponse.CategoryList)categoryForVerify.getCategory_list().get(0)).getSecond_class()).title("\u9996\u9875").build());
        }
        SubmitAuditRequest build = SubmitAuditRequest.builder().item_list(itemLists).build();
        log.info("submit audit req :{}", (Object)JSONObject.toJSONString((Object)build));
        Integer auditid = null;
        MiniprogramRelease update = new MiniprogramRelease();
        update.setAuditStatus(Integer.valueOf(AuditStatusEnum.AUDIT.status()));
        update.setMpid(wechatMp.getId());
        update.setAuditVersion(release.getAuditVersion());
        update.setTemplateId(release.getTemplateId());
        try {
            auditid = miniprogram.code.submitAudit(build);
            this.update(update);
        }
        catch (WechatException e) {
            log.error(e.getMessage());
            if (Double.valueOf(e.getCode().toString()).intValue() == 85009) {
                this.update(update);
                throw new CustomException("\u60a8\u5df2\u6709\u6b63\u5728\u5ba1\u6838\u7684\u7248\u672c\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4");
            }
            throw new CustomException(e.getMessage());
        }
        log.info("\u5ba1\u6838ID\uff1a" + auditid);
        return auditid;
    }

    private void commitCode(MiniprogramRelease release, WechatMp wechatMp) {
        Miniprogram miniprogram = this.wechat3rdPlatformHandler.miniprogram(wechatMp.getAppid());
        JSONObject extJson = this.getExtJson(wechatMp);
        try {
            CommitCodeRequest commitCodeRequest = CommitCodeRequest.builder().template_id(release.getTemplateId().intValue()).user_desc("\u6a21\u7248" + release.getTemplateId() + "\uff0c\u7248\u672c" + release.getAuditVersion() + "\uff0c\u5546\u6237" + extJson.getJSONObject("ext").get((Object)"merchantId")).user_version(release.getAuditVersion()).ext_json(extJson.toJSONString()).build();
            miniprogram.code.commitCode(commitCodeRequest);
            log.info("mall mp commitCode request :{}", (Object)JSONObject.toJSONString((Object)commitCodeRequest));
        }
        catch (WechatException e) {
            log.error(e.getMessage());
            throw new CustomException(e.getMessage());
        }
    }

    private JSONObject getExtJson(WechatMp wechatMp) {
        MiniprogramRelease miniprogramRelease = this.getMiniprogramReleaseByMpid(wechatMp.getId());
        String extJSONStr = "";
        try {
            extJSONStr = ResourcesFileReader.read(this.getClass(), (String)"ext.json");
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage());
        }
        JSONObject extJson = JSONObject.parseObject((String)extJSONStr);
        JSONObject miniprogramRedirectConfiguration = this.bizvaneInterface.getMiniprogramRedirectConfiguration(wechatMp.getAppid());
        JSONArray appidArr = new JSONArray();
        appidArr.add((Object)miniprogramRedirectConfiguration.getString("appId"));
        extJson.put("extAppid", (Object)wechatMp.getAppid());
        extJson.put("navigateToMiniProgramAppIdList", (Object)appidArr);
        extJson.getJSONObject("ext").put("appid", (Object)wechatMp.getAppid());
        extJson.getJSONObject("ext").put("name", (Object)wechatMp.getNickName());
        extJson.getJSONObject("ext").put("merchantId", (Object)miniprogramRelease.getMerchantId());
        return extJson;
    }

    private void setDomain(String appid, Wechat3rdPlatform wechat3rdPlatform) {
        MiniProgramDomainSettings settings = new MiniProgramDomainSettings();
        settings.setDownloaddomain(wechat3rdPlatform.getMiniprogram().getDownloadDomain());
        settings.setRequestdomain(wechat3rdPlatform.getMiniprogram().getRequestDomain());
        settings.setUploaddomain(wechat3rdPlatform.getMiniprogram().getUploadDomain());
        settings.setWsrequestdomain(wechat3rdPlatform.getMiniprogram().getWebviewDomain());
        this.wechat3rdPlatformHandler.miniprogram((String)appid).domain.miniProgramDomain("set", settings);
    }

    public List<MiniprogramRelease> selects() {
        return this.miniprogramReleaseMapper.selectsAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={RuntimeException.class})
    public MiniprogramRelease add(MiniprogramRelease miniprogramRelease) {
        Assert.notNull((Object)miniprogramRelease.getMerchantId(), (String)"invalid merchantId ");
        this.wechatMpService.save(miniprogramRelease.getWechatMp());
        if (miniprogramRelease.getWechatMp().getIsMiniprogram().booleanValue()) {
            miniprogramRelease.setMpid(miniprogramRelease.getWechatMp().getId());
            miniprogramRelease.setGmtCreate(new Date());
            String string = ("miniprogram_release_mpid" + miniprogramRelease.getWechatMp().getId()).intern();
            synchronized (string) {
                MiniprogramRelease release = (MiniprogramRelease)this.miniprogramReleaseMapper.selectOne((Object)MiniprogramRelease.builder().mpid(miniprogramRelease.getWechatMp().getId()).build());
                if (release == null) {
                    this.miniprogramReleaseMapper.insertSelective((Object)miniprogramRelease);
                } else {
                    miniprogramRelease.setId(release.getId());
                    this.miniprogramReleaseMapper.updateByPrimaryKeySelective((Object)miniprogramRelease);
                }
            }
        }
        return miniprogramRelease;
    }

    public MiniprogramRelease getMiniprogramReleaseByMerchantid(Integer merchantId) {
        MiniprogramRelease release = new MiniprogramRelease();
        release.setMerchantId(merchantId);
        MiniprogramRelease currentRelease = (MiniprogramRelease)this.miniprogramReleaseMapper.selectOne((Object)release);
        Assert.notNull((Object)currentRelease, (String)("merchantId " + merchantId + " cannot find release record "));
        return currentRelease;
    }
}

