/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.mapper.IntegralConfigMapper;
import com.wmeimob.fastboot.bizvane.service.IntegralConfigService;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class IntegralConfigServiceImpl
implements IntegralConfigService {
    private static final Logger log = LoggerFactory.getLogger(IntegralConfigServiceImpl.class);
    @Autowired
    private IntegralConfigMapper integralConfigMapper;

    public IntegralConfig addConfig(IntegralConfig config) {
        log.info("\u57fa\u672c\u914d\u7f6e\u65b0\u589e\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)config.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)config.getAwaitOrderDelivery(), (String)"\u5df2\u53d1\u8d27\u8ba2\u5355\u81ea\u52a8\u7b7e\u6536\u65f6\u95f4(\u5929)");
        InputValidator.checkEmpty((Object)config.getAwaitOrderReturnable(), (String)"\u5df2\u7b7e\u6536\u8ba2\u5355\u81ea\u52a8\u5173\u95ed\u9000\u6362\u65f6\u95f4(\u5929)");
        config.setGmtCreate(new Date());
        this.integralConfigMapper.insertSelective((Object)config);
        return config;
    }

    public IntegralConfig updateConfig(IntegralConfig config) {
        log.info("\u57fa\u672c\u914d\u7f6e\u4fee\u6539\u3002\u3002\u3002");
        InputValidator.checkEmpty((Object)config.getId(), (String)"\u57fa\u672c\u914d\u7f6e\u4e3b\u952e");
        InputValidator.checkEmpty((Object)config.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)config.getAwaitOrderDelivery(), (String)"\u5df2\u53d1\u8d27\u8ba2\u5355\u81ea\u52a8\u7b7e\u6536\u65f6\u95f4(\u5929)");
        InputValidator.checkEmpty((Object)config.getAwaitOrderReturnable(), (String)"\u5df2\u7b7e\u6536\u8ba2\u5355\u81ea\u52a8\u5173\u95ed\u9000\u6362\u65f6\u95f4(\u5929)");
        config.setGmtModified(new Date());
        this.integralConfigMapper.updateByPrimaryKey((Object)config);
        return config;
    }

    public IntegralConfig getConfig(Integer merchantId) {
        log.info("\u83b7\u53d6\u57fa\u672c\u914d\u7f6e,\u54c1\u724cid\u4e3a{}", (Object)merchantId);
        Example example = new Example(IntegralConfig.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        IntegralConfig config = (IntegralConfig)this.integralConfigMapper.selectOneByExample((Object)example);
        return config;
    }
}

