/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.mapper.ConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.util.InputValidator;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class ConfigServiceImpl
implements ConfigService {
    @Resource
    private ConfigMapper configMapper;
    @Resource
    private GoodsClassifyMapper goodsClassifyMapper;

    public Config add(Config config) {
        GoodsClassify classify;
        this.verify(config);
        config.setGmtCreate(new Date());
        this.configMapper.insertSelective((Object)config);
        Example example = new Example(GoodsClassify.class);
        if (Boolean.TRUE.equals(config.getBargain())) {
            example.createCriteria().andEqualTo("merchantId", (Object)config.getMerchantId()).andEqualTo("coding", (Object)"bargain");
            classify = (GoodsClassify)this.goodsClassifyMapper.selectOneByExample((Object)example);
            if (classify != null) {
                classify.setPic(config.getBargainHeadUrl());
                this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)classify);
            }
        }
        if (Boolean.TRUE.equals(config.getAssemble())) {
            example.createCriteria().andEqualTo("merchantId", (Object)config.getMerchantId()).andEqualTo("coding", (Object)"assemble");
            classify = (GoodsClassify)this.goodsClassifyMapper.selectOneByExample((Object)example);
            if (classify != null) {
                classify.setPic(config.getAssembleHeadUrl());
                this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)classify);
            }
        }
        return config;
    }

    public int update(Config config) {
        GoodsClassify classify;
        this.verify(config);
        config.setGmtModified(new Date());
        int i = this.configMapper.updateByPrimaryKeySelective((Object)config);
        Example example = new Example(GoodsClassify.class);
        if (Boolean.TRUE.equals(config.getAssemble())) {
            example.createCriteria().andEqualTo("merchantId", (Object)config.getMerchantId()).andEqualTo("coding", (Object)"assemble");
            classify = (GoodsClassify)this.goodsClassifyMapper.selectOneByExample((Object)example);
            if (classify != null) {
                classify.setPic(config.getAssembleHeadUrl());
                this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)classify);
            }
        }
        if (Boolean.TRUE.equals(config.getBargain())) {
            example.createCriteria().andEqualTo("merchantId", (Object)config.getMerchantId()).andEqualTo("coding", (Object)"bargain");
            classify = (GoodsClassify)this.goodsClassifyMapper.selectOneByExample((Object)example);
            if (classify != null) {
                classify.setPic(config.getBargainHeadUrl());
                this.goodsClassifyMapper.updateByPrimaryKeySelective((Object)classify);
            }
        }
        return i;
    }

    private void verify(Config config) {
        InputValidator.checkNumber((Integer)1, (Integer)30, (Integer)config.getAwaitOrderConfirm(), (String)"\u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u65f6\u95f4");
        InputValidator.checkNumber((Integer)1, (Integer)30, (Integer)config.getAwaitOrderEvaluation(), (String)"\u81ea\u52a8\u597d\u8bc4\u65f6\u95f4");
        InputValidator.checkNaturalNumber((Integer)config.getAwaitOrderPayMinute(), (String)"\u5f85\u652f\u4ed8\u8ba2\u5355\u5173\u95ed\u65f6\u95f4");
        InputValidator.checkNumber((Integer)1, (Integer)30, (Integer)config.getAwaitOrderReturn(), (String)"\u81ea\u52a8\u5173\u95ed\u9000\u6b3e/\u9000\u8d27\u65f6\u95f4");
        if (config.getIsDistribution().booleanValue()) {
            InputValidator.checkNaturalNumber((Integer)config.getCommission(), (String)"\u9ed8\u8ba4\u8fd4\u4f63");
        }
        if (config.getIsFreeShipping().booleanValue()) {
            InputValidator.checkNaturalNumber((BigDecimal)config.getFreePrice(), (String)"\u5305\u90ae\u91d1\u989d");
        }
    }
}

