/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.ActivityGift;
import com.wmeimob.fastboot.bizvane.entity.ActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.ActivityRule;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleCombination;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleGift;
import com.wmeimob.fastboot.bizvane.entity.ActivityStipulation;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleCombinationMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityStipulationMapper;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActivityStipulationMapper activityStipulationMapper;
    @Autowired
    private ActivityGoodsMapper activityGoodsMapper;
    @Autowired
    private ActivityGiftMapper activityGiftMapper;
    @Autowired
    private ActivityRuleMapper activityRuleMapper;
    @Autowired
    private ActivityRuleCombinationMapper activityRuleCombinationMapper;
    @Autowired
    private ActivityRuleGiftMapper activityRuleGiftMapper;

    public Activity add(Activity activity) {
        InputValidator.checkLengthRange((Object)activity.getName(), (int)1, (int)50, (String)"\u6d3b\u52a8\u540d\u79f0");
        InputValidator.checkEmpty((Object)activity.getBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        InputValidator.checkEmpty((Object)activity.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        InputValidator.checkDateTime((Date)activity.getBeginDate(), (Date)activity.getEndDate());
        Date date = new Date();
        activity.setGmtCreate(date);
        this.activityMapper.insertSelective((Object)activity);
        if (activity.getType() == 1) {
            List stipulationList = activity.getStipulationList();
            if (stipulationList == null || stipulationList.size() < 1) {
                throw new CustomException("\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (Object stipulation : stipulationList) {
                InputValidator.checkNumber((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("1"), (BigDecimal)stipulation.getDiscount(), (String)"\u6298\u6263\u8303\u56f4");
                stipulation.setActivityId(activity.getId());
                stipulation.setGmtCreate(date);
            }
            this.activityStipulationMapper.insertList(stipulationList);
            List goodsList = activity.getGoodsList();
            if (goodsList == null || goodsList.size() < 1) {
                throw new CustomException("\u5546\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
            }
            for (ActivityGoods goods : goodsList) {
                goods.setMerchantId(activity.getMerchantId());
                goods.setBeginDate(activity.getBeginDate());
                goods.setEndDate(activity.getEndDate());
                Integer count = this.activityGoodsMapper.selectCountGoodsByActivity(goods);
                if (count > 0) {
                    throw new CustomException("\u5546\u54c1\uff1a" + goods.getGoodsName() + "\u5df2\u53c2\u4e0e\u5176\u4ed6\u6d3b\u52a8");
                }
                goods.setActivityId(activity.getId());
                goods.setGmtCreate(date);
            }
            this.activityGoodsMapper.insertList(goodsList);
        } else {
            List activityGiftList = activity.getActivityGiftList();
            if (activityGiftList == null || activityGiftList.size() < 1) {
                throw new CustomException("\u5546\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
            }
            for (ActivityGift goods : activityGiftList) {
                goods.setActivityId(activity.getId());
                goods.setGmtCreate(date);
            }
            this.activityGiftMapper.insertList(activityGiftList);
        }
        return activity;
    }

    @Transactional
    public int delete(Integer id) {
        this.activityMapper.deleteByPrimaryKey((Object)id);
        Example example = new Example(ActivityGoods.class);
        example.createCriteria().andEqualTo("activityId", (Object)id);
        int i = this.activityGoodsMapper.deleteByExample((Object)example);
        Example rule = new Example(ActivityRule.class);
        example.createCriteria().andEqualTo("activityId", (Object)id);
        List rules = this.activityRuleMapper.selectByExample((Object)rule);
        if (rules.size() > 0) {
            for (ActivityRule rule1 : rules) {
                Example com = new Example(ActivityRuleCombination.class);
                com.createCriteria().andEqualTo("ruleId", (Object)rule1.getId());
                this.activityRuleCombinationMapper.deleteByExample((Object)com);
                Example gift = new Example(ActivityRuleGift.class);
                gift.createCriteria().andEqualTo("ruleId", (Object)rule1.getId());
                this.activityRuleGiftMapper.deleteByExample((Object)gift);
            }
        }
        this.activityRuleMapper.deleteByExample((Object)rule);
        return i;
    }

    public int update(Activity activity) {
        block12: {
            Date date;
            block11: {
                List goodsList;
                InputValidator.checkLengthRange((Object)activity.getName(), (int)1, (int)50, (String)"\u6d3b\u52a8\u540d\u79f0");
                InputValidator.checkEmpty((Object)activity.getBeginDate(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
                InputValidator.checkEmpty((Object)activity.getEndDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
                InputValidator.checkDateTime((Date)activity.getBeginDate(), (Date)activity.getEndDate());
                date = new Date();
                activity.setGmtModified(date);
                if (activity.getType() != 1) break block11;
                List stipulationList = activity.getStipulationList();
                if (stipulationList != null) {
                    for (ActivityStipulation stipulation : stipulationList) {
                        stipulation.setActivityId(activity.getId());
                        stipulation.setGmtCreate(date);
                        if (stipulation.getId() == null) {
                            stipulation.setActivityId(activity.getId());
                            stipulation.setGmtCreate(date);
                            this.activityStipulationMapper.insertSelective((Object)stipulation);
                            continue;
                        }
                        if (stipulation.getIsDelete().booleanValue()) {
                            this.activityStipulationMapper.deleteByPrimaryKey((Object)stipulation.getId());
                            continue;
                        }
                        this.activityStipulationMapper.updateByPrimaryKeySelective((Object)stipulation);
                    }
                }
                if ((goodsList = activity.getGoodsList()) == null) break block12;
                for (ActivityGoods goods : goodsList) {
                    goods.setActivityId(activity.getId());
                    goods.setGmtCreate(date);
                    if (goods.getId() == null) {
                        goods.setMerchantId(activity.getMerchantId());
                        goods.setBeginDate(activity.getBeginDate());
                        goods.setEndDate(activity.getEndDate());
                        Integer count = this.activityGoodsMapper.selectCountGoodsByActivity(goods);
                        if (count > 0) {
                            throw new CustomException("\u5546\u54c1\uff1a" + goods.getGoodsName() + "\u5df2\u53c2\u4e0e\u5176\u4ed6\u5df2\u542f\u7528\u7684\u6d3b\u52a8");
                        }
                        goods.setActivityId(activity.getId());
                        goods.setGmtCreate(date);
                        this.activityGoodsMapper.insertSelective((Object)goods);
                        continue;
                    }
                    if (!goods.getIsDelete().booleanValue()) continue;
                    this.activityGoodsMapper.deleteByPrimaryKey((Object)goods.getId());
                }
                break block12;
            }
            List goodsList = activity.getActivityGiftList();
            if (goodsList != null) {
                for (ActivityGift goods : goodsList) {
                    goods.setActivityId(activity.getId());
                    goods.setGmtCreate(date);
                    if (goods.getId() == null) {
                        goods.setActivityId(activity.getId());
                        goods.setGmtCreate(date);
                        this.activityGiftMapper.insertSelective((Object)goods);
                        continue;
                    }
                    if (goods.getIsDelete().booleanValue()) {
                        this.activityGiftMapper.deleteByPrimaryKey((Object)goods);
                        continue;
                    }
                    this.activityGiftMapper.updateByPrimaryKey((Object)goods);
                }
            }
        }
        return this.activityMapper.updateByPrimaryKeySelective((Object)activity);
    }

    public List<Activity> findByCondition(Activity activity) {
        return this.activityMapper.selectList(activity);
    }

    public Activity findById(Integer id) {
        return this.activityMapper.findById(id);
    }

    public int deleteGoodsById(Integer id) {
        return this.activityGoodsMapper.deleteByPrimaryKey((Object)id);
    }

    public int deleteStipulationById(Integer id) {
        return this.activityStipulationMapper.deleteByPrimaryKey((Object)id);
    }

    public void deleteActivityGoods(Integer id) {
        Example example = new Example(ActivityGoods.class);
        example.createCriteria().andEqualTo("goodsId", (Object)id);
        this.activityGoodsMapper.deleteByExample((Object)example);
    }
}

