/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral_wx;

import com.wmeimob.fastboot.bizvane.entity.IntegralConfig;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.service.IntegralConfigService;
import com.wmeimob.fastboot.bizvane.service.IntegralRefundOrderService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wx/refundOrder"})
public class WxIntegralRefundOrderController {
    private static final Logger log = LoggerFactory.getLogger(WxIntegralRefundOrderController.class);
    @Autowired
    private IntegralConfigService integralConfigService;
    @Autowired
    private IntegralRefundOrderService integralRefundOrderService;

    @RequestMapping(value={"/getRejectedExplain"}, method={RequestMethod.GET})
    public String getRejectedExplain(@RequestParam(value="merchantId") Integer merchantId) {
        log.info("\u83b7\u53d6\u9000\u8d27\u8bf4\u660e");
        IntegralConfig config = this.integralConfigService.getConfig(merchantId);
        String rejectedExplain = "";
        if (config != null) {
            rejectedExplain = config.getRejectedExplain();
        }
        return rejectedExplain;
    }

    @RequestMapping(value={"/submitReturnGoods"}, method={RequestMethod.POST})
    public RestResult submitReturnGoods(@RequestBody IntegralRefundOrder integralRefundOrder) {
        log.info("\u63d0\u4ea4\u9000\u8d27\u7533\u8bf7");
        InputValidator.checkEmpty((Object)integralRefundOrder.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)integralRefundOrder.getOrderNo(), (String)"\u539f\u8d2d\u4e70\u8ba2\u5355\u7f16\u53f7");
        InputValidator.checkEmpty((Object)integralRefundOrder.getOrderDetailId(), (String)"\u539f\u8d2d\u4e70\u8ba2\u5355\u660e\u7ec6id");
        InputValidator.checkEmpty((Object)integralRefundOrder.getRefundType(), (String)"\u9000\u8d27\u65b9\u5f0f");
        InputValidator.checkEmpty((Object)integralRefundOrder.getRefundReason(), (String)"\u9000\u8d27\u539f\u56e0");
        this.integralRefundOrderService.submitReturnGoods(integralRefundOrder);
        return RestResult.success();
    }

    @RequestMapping(value={"/submitRefundLogistics"}, method={RequestMethod.POST})
    public RestResult submitRefundLogistics(@RequestBody IntegralRefundOrder integralRefundOrder) {
        log.info("\u63d0\u4ea4\u9000\u8d27\u7269\u6d41\u4fe1\u606f");
        InputValidator.checkEmpty((Object)integralRefundOrder.getRefundNo(), (String)"\u9000\u8d27\u8ba2\u5355\u7f16\u53f7");
        InputValidator.checkEmpty((Object)integralRefundOrder.getRefundShippingCompany(), (String)"\u5feb\u9012\u516c\u53f8");
        InputValidator.checkEmpty((Object)integralRefundOrder.getRefundCompanyCode(), (String)"\u5feb\u9012\u516c\u53f8\u7f16\u53f7");
        InputValidator.checkEmpty((Object)integralRefundOrder.getRefundShippingNo(), (String)"\u5feb\u9012\u5355\u53f7");
        this.integralRefundOrderService.submitRefundLogistics(integralRefundOrder);
        return RestResult.success();
    }
}

