/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral_wx;

import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wx/orders"})
public class WxIntegralOrdersController {
    private static final Logger log = LoggerFactory.getLogger(WxIntegralOrdersController.class);
    @Autowired
    private IntegralOrdersService integralOrdersService;

    @RequestMapping(value={"/confirmGoods"}, method={RequestMethod.POST})
    public Map confirmGoods(@RequestBody IntegralOrders integralOrders) {
        log.info("\u786e\u8ba4\u4e0b\u5355...");
        HashMap<String, Object> map = new HashMap<String, Object>();
        InputValidator.checkEmpty((Object)integralOrders.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)integralOrders.getMemberCode(), (String)"\u4f1a\u5458code");
        InputValidator.checkEmpty((Object)integralOrders.getMemberCardNo(), (String)"\u4f1a\u5458\u5361\u53f7");
        InputValidator.checkEmpty((Object)integralOrders.getMemberPhone(), (String)"\u4f1a\u5458\u7535\u8bdd");
        InputValidator.checkEmpty((Object)integralOrders.getGoodId(), (String)"\u5546\u54c1id");
        InputValidator.checkEmpty((Object)integralOrders.getSaleQuantity(), (String)"\u8d2d\u4e70\u6570\u91cf");
        if (integralOrders.getSaleQuantity() < 1) {
            throw new CustomException("\u8d2d\u4e70\u6570\u91cf\u4e0d\u5f97\u5c0f\u4e8e1\u4ef6\u3002");
        }
        InputValidator.checkEmpty((Object)integralOrders.getGoodSkuNo(), (String)"\u5546\u54c1sku\u7f16\u53f7");
        String distributionMode = this.integralOrdersService.getDistributionModeBySkuNo(integralOrders.getGoodSkuNo());
        if ("0".equals(distributionMode)) {
            this.checkEmptyByShipping(integralOrders);
        } else if ("2".equals(distributionMode) && integralOrders.getOrderType().equals("0")) {
            this.checkEmptyByShipping(integralOrders);
        }
        IntegralOrders orders = this.integralOrdersService.confirm(integralOrders);
        if (orders != null) {
            map.put("code", 0);
            map.put("msg", "\u64cd\u4f5c\u6210\u529f");
            map.put("data", orders.getOrderNo());
        } else {
            map.put("code", -1);
            map.put("msg", "\u64cd\u4f5c\u5931\u8d25");
        }
        return map;
    }

    @RequestMapping(value={"/getOrderListByStatus/{merchantId}/{orderStatus}/{memberCode}"}, method={RequestMethod.GET})
    public List<IntegralOrders> getOrderListByStatus(@PathVariable(value="merchantId") Integer merchantId, @PathVariable(value="orderStatus") String orderStatus, @PathVariable(value="memberCode") String memberCode) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u5217\u8868...");
        log.info("merchantId/orderStatus/memberCode:{}", (Object)(merchantId + "/" + orderStatus + "/" + memberCode));
        return this.integralOrdersService.getOrderListByStatus(merchantId, orderStatus, memberCode);
    }

    @RequestMapping(value={"/getOrderById/{orderId}"}, method={RequestMethod.GET})
    public IntegralOrders getOrderById(@PathVariable(value="orderId") Integer orderId) {
        log.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5...");
        return this.integralOrdersService.getOrderById(orderId);
    }

    private void checkEmptyByShipping(IntegralOrders integralOrders) {
        if (StringUtils.isEmpty((Object)integralOrders.getShippingName()) || StringUtils.isEmpty((Object)integralOrders.getShippingMobile()) || StringUtils.isEmpty((Object)integralOrders.getShippingProvince()) || StringUtils.isEmpty((Object)integralOrders.getShippingCity()) || StringUtils.isEmpty((Object)integralOrders.getShippingDistrict()) || StringUtils.isEmpty((Object)integralOrders.getShippingAddress()) || "undefined".equals(integralOrders.getShippingName()) || "undefined".equals(integralOrders.getShippingMobile()) || "undefined".equals(integralOrders.getShippingProvince()) || "undefined".equals(integralOrders.getShippingCity()) || "undefined".equals(integralOrders.getShippingDistrict()) || "undefined".equals(integralOrders.getShippingAddress())) {
            throw new CustomException("\u8bf7\u5b8c\u5584\u6536\u8d27\u4fe1\u606f\uff01");
        }
    }
}

