/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.integral;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.integral.ProvinceInfoDTO;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralRefundOrder;
import com.wmeimob.fastboot.bizvane.service.IntegralOrdersService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.InputValidator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integral/orders"})
@Api(description="\u79ef\u5206\u5546\u57ce\u8ba2\u5355API")
public class IntegralOrdersController {
    private static final Logger log = LoggerFactory.getLogger(IntegralOrdersController.class);
    @Autowired
    private IntegralOrdersService integralOrdersService;

    @ApiOperation(value="\u8ba2\u5355\u5206\u9875")
    @RequestMapping(value={"/getOrdersList"}, method={RequestMethod.POST})
    public PageInfo getOrdersList(@RequestBody IntegralOrders integralOrders) {
        log.info("\u67e5\u8be2\u79ef\u5206\u8ba2\u5355\u5206\u9875\u5217\u8868");
        PageHelper.startPage((int)integralOrders.getPageIndex(), (int)integralOrders.getPageSize());
        List list = this.integralOrdersService.getOrdersList(integralOrders);
        list.forEach(e -> {
            if (e.getSaleIntegral() != null && e.getSaleQuantity() != null) {
                e.setTotalIntegral(Integer.valueOf(e.getSaleIntegral() * e.getSaleQuantity()));
            }
        });
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true)})
    @RequestMapping(value={"/getOrder"}, method={RequestMethod.GET})
    public IntegralOrders getOrder(@RequestParam(value="orderId") Integer orderId, @RequestParam(value="merchantId") Integer merchantId) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u3002\u3002\u3002\u3002orderId:{},merchantId:{}", (Object)orderId, (Object)merchantId);
        IntegralOrders integralOrders = new IntegralOrders();
        integralOrders.setId(orderId);
        integralOrders.setMerchantId(merchantId);
        integralOrders = (IntegralOrders)this.integralOrdersService.getOrdersList(integralOrders).get(0);
        return integralOrders;
    }

    @ApiOperation(value="\u8bbe\u7f6e\u7269\u6d41\u4fe1\u606f")
    @RequestMapping(value={"/setCourier"}, method={RequestMethod.POST})
    public RestResult setCourier(@RequestBody IntegralOrders integralOrders) {
        log.info("\u8bbe\u7f6e\u7269\u6d41\u4fe1\u606f");
        InputValidator.checkEmpty((Object)integralOrders.getId(), (String)"\u8ba2\u5355id");
        InputValidator.checkEmpty((Object)integralOrders.getCourierCompanyName(), (String)"\u5feb\u9012\u516c\u53f8\u540d\u79f0");
        InputValidator.checkEmpty((Object)integralOrders.getCourierCompanyCode(), (String)"\u5feb\u9012\u516c\u53f8\u7f16\u7801");
        InputValidator.checkEmpty((Object)integralOrders.getCourierNo(), (String)"\u5feb\u9012\u5355\u53f7");
        this.integralOrdersService.setCourier(integralOrders);
        return RestResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u6536\u8d27\u4fe1\u606f")
    @RequestMapping(value={"/updateCourierAddress"}, method={RequestMethod.POST})
    private RestResult updateCourierAddress(@RequestBody IntegralOrders integralOrders) {
        log.info("\u4fee\u6539\u8ba2\u5355\u6536\u8d27\u4fe1\u606f");
        InputValidator.checkEmpty((Object)integralOrders.getId(), (String)"\u8ba2\u5355id");
        InputValidator.checkEmpty((Object)integralOrders.getShippingName(), (String)"\u6536\u8d27\u4eba");
        InputValidator.checkEmpty((Object)integralOrders.getShippingMobile(), (String)"\u6536\u8d27\u4eba\u624b\u673a");
        InputValidator.checkEmpty((Object)integralOrders.getShippingProvince(), (String)"\u6536\u8d27\u7701\u4efd");
        InputValidator.checkEmpty((Object)integralOrders.getShippingCity(), (String)"\u6536\u8d27\u57ce\u5e02");
        InputValidator.checkEmpty((Object)integralOrders.getShippingDistrict(), (String)"\u6536\u8d27\u884c\u653f\u533a");
        InputValidator.checkEmpty((Object)integralOrders.getShippingAddress(), (String)"\u6536\u8d27\u8be6\u7ec6\u5730\u5740");
        this.integralOrdersService.updateCourierAddress(integralOrders);
        return RestResult.success();
    }

    @ApiOperation(value="\u9000\u8d27\u5ba1\u6279")
    @RequestMapping(value={"/refundAuditor"}, method={RequestMethod.POST})
    private RestResult refundAuditor(@RequestBody IntegralRefundOrder integralRefundOrder) {
        log.info("\u9000\u8d27\u5ba1\u6279...");
        InputValidator.checkEmpty((Object)integralRefundOrder.getOrderNo(), (String)"\u8ba2\u5355\u53f7");
        InputValidator.checkEmpty((Object)integralRefundOrder.getId(), (String)"\u9000\u8d27\u8ba2\u5355id");
        InputValidator.checkEmpty((Object)integralRefundOrder.getMerchantId(), (String)"\u54c1\u724cid");
        InputValidator.checkEmpty((Object)integralRefundOrder.getAuditor(), (String)"\u5ba1\u6279\u4eba");
        InputValidator.checkEmpty((Object)integralRefundOrder.getAuditType(), (String)"\u5ba1\u6279\u7c7b\u578b");
        this.integralOrdersService.auditor(integralRefundOrder);
        return RestResult.success();
    }

    @ApiOperation(value="\u79ef\u5206\u9000\u8d27\u8ba2\u5355\u5206\u9875")
    @RequestMapping(value={"/getRefundOrders"}, method={RequestMethod.POST})
    public PageInfo getRefundOrders(@RequestBody IntegralRefundOrder integralRefundOrder) {
        log.info("\u67e5\u8be2\u79ef\u5206\u9000\u8d27\u8ba2\u5355\u5206\u9875\u5217\u8868");
        PageHelper.startPage((int)integralRefundOrder.getPageIndex(), (int)integralRefundOrder.getPageSize());
        List list = this.integralOrdersService.getRefundOrders(integralRefundOrder);
        return new PageInfo(list);
    }

    @ApiOperation(value="\u786e\u8ba4\u9000\u8fd8\u79ef\u5206")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", value="\u8ba2\u5355\u7f16\u53f7", dataType="String", paramType="query", required=true), @ApiImplicitParam(name="merchantId", value="\u54c1\u724cid", dataType="int", paramType="query", required=true)})
    @RequestMapping(value={"/refund"}, method={RequestMethod.GET})
    public RestResult refund(@RequestParam(value="orderNo") String orderNo, @RequestParam(value="merchantId") Integer merchantId) {
        log.info("\u786e\u8ba4\u9000\u8fd8\u79ef\u5206");
        IntegralOrders orders = this.integralOrdersService.refund(orderNo, merchantId, null, null);
        return orders != null ? RestResult.success() : RestResult.fail();
    }

    @ApiOperation(value="\u83b7\u53d6\u7701\u4efd")
    @RequestMapping(value={"/getProvince"}, method={RequestMethod.GET})
    public List<ProvinceInfoDTO> getProvince() {
        log.info("\u83b7\u53d6\u7701\u4efd/\u57ce\u5e02/\u533a\u57df");
        return this.integralOrdersService.getCity();
    }
}

