/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.open.entity.MiniprogramRelease;
import com.wmeimob.fastboot.open.service.MiniprogramService;
import com.wmeimob.wechat.open.exception.LoaderNotFoundException;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMp;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"miniprogram"})
public class MiniprogramController {
    @Resource
    private MiniprogramService miniprogramService;

    @PostMapping(value={"inject"})
    public RestResult injectMiniprogramInfo(@RequestBody MiniprogramRelease release) {
        this.miniprogramService.add(release);
        return RestResult.success();
    }

    @GetMapping
    public PageInfo<MiniprogramRelease> queryByCondition(WechatMp condition) {
        PageContext.startPage();
        return new PageInfo(this.miniprogramService.selects());
    }

    @PostMapping(value={"submit"})
    public void submit(@RequestBody MiniprogramRelease release) {
        this.miniprogramService.oneKeySubmit(release);
    }

    @PostMapping(value={"qrcode"})
    public String getTestQrCode(@RequestBody MiniprogramRelease release) throws UnsupportedEncodingException, LoaderNotFoundException {
        return this.miniprogramService.testQrCode(release);
    }

    @GetMapping(value={"audit"})
    public String getAuditResult(Integer mpid) {
        String reason = this.miniprogramService.queryAuditResult(mpid);
        return reason;
    }

    @PostMapping(value={"publish"})
    public RestResult publish(Integer mpid) {
        this.miniprogramService.publish(mpid);
        return RestResult.success();
    }
}

