/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.open.mapper.MiniprogramReleaseMapper;
import com.wmeimob.fastboot.starter.wechat.mapper.WechatMchMapper;
import com.wmeimob.fastboot.starter.wechat.mapper.WechatMpMapper;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"mch"})
public class MchController {
    @Autowired
    private WechatMchMapper wechatMchMapper;
    @Autowired
    private WechatMpMapper wechatMpMapper;
    @Autowired
    private MiniprogramReleaseMapper miniprogramReleaseMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;

    @GetMapping
    public WechatMchNew loadMchInfo(@RequestHeader(value="merchantId") Integer merchantId) {
        Example example = new Example(WechatMchNew.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
        return mchNew;
    }

    @PostMapping
    public RestResult saveMchInfo(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="p12Data") MultipartFile uploadFile, WechatMchNew wechatMch) throws IOException {
        if (uploadFile != null) {
            wechatMch.setP12(uploadFile.getBytes());
            wechatMch.setP12SetFlag(Boolean.valueOf(true));
        } else {
            wechatMch.setP12SetFlag(Boolean.valueOf(false));
        }
        String appid = this.bizvaneInterface.getAppid(merchantId);
        if (StringUtils.isEmpty((Object)appid)) {
            throw new CustomException("\u54c1\u724cID:[" + merchantId + "],\u672a\u5c06\u5c0f\u7a0b\u5e8f\u6388\u6743\u81f3\u7b2c\u4e09\u65b9\u5f00\u653e\u5e73\u53f0\u3002");
        }
        Example example = new Example(WechatMchNew.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
        if (mchNew == null) {
            wechatMch.setMerchantId(merchantId);
            wechatMch.setAppId(appid);
            this.wechatMchNewMapper.insertSelective((Object)wechatMch);
        } else {
            mchNew.setAppId(appid);
            mchNew.setMchKey(wechatMch.getMchKey());
            mchNew.setMchNo(wechatMch.getMchNo());
            mchNew.setP12(wechatMch.getP12());
            mchNew.setP12SetFlag(wechatMch.getP12SetFlag());
            this.wechatMchNewMapper.updateByPrimaryKeySelective((Object)mchNew);
        }
        return RestResult.success();
    }
}

