/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropHead;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValue;
import com.wmeimob.fastboot.bizvane.service.GoodsPropService;
import com.wmeimob.fastboot.core.annotation.Page;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods-prop"})
public class GoodsPropController {
    @Autowired
    private GoodsPropService goodsPropService;

    @PostMapping
    public RestResult add(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsPropHead goodsPropHead) {
        goodsPropHead.setMerchantId(merchantId);
        this.goodsPropService.add((Serializable)goodsPropHead);
        return RestResult.success();
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@PathVariable(value="id") Integer id, @RequestBody GoodsPropHead toodsTag) {
        int result = this.goodsPropService.update((Serializable)toodsTag);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult delete(@PathVariable(value="id") Integer id) {
        int result = this.goodsPropService.delete(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"propValue/{id}"})
    public RestResult deletePropValue(@PathVariable(value="id") Integer id) {
        int result = this.goodsPropService.deletePropValue(id);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @Page
    @GetMapping
    public PageInfo list(@RequestHeader(value="merchantId") Integer merchantId, GoodsPropHead goodsPropHead) {
        goodsPropHead.setMerchantId(merchantId);
        List list = this.goodsPropService.findByCondition((Serializable)goodsPropHead);
        return new PageInfo(list);
    }

    @GetMapping(value={"selectByHeadId"})
    public List<GoodsPropValue> selectByHeadId(Integer id) {
        return this.goodsPropService.selectByHeadId(id);
    }
}

