/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.service.GoodsClassifyService;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods-classify"})
public class GoodsClassifyController {
    @Autowired
    private GoodsClassifyService goodsClassifyService;

    @GetMapping
    public Map<String, Object> list(@RequestHeader(value="merchantId") Integer merchantId) {
        GoodsClassify[] array = this.goodsClassifyService.findByAll(merchantId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", 0);
        map.put("msg", "ok");
        map.put("data", array);
        return map;
    }

    @GetMapping(value={"{id}"})
    public List<GoodsClassify> selectListByPid(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        return this.goodsClassifyService.selectListByPid(merchantId, id);
    }

    @PostMapping
    public RestResult insertGoodsClassify(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsClassify goodsClassify) {
        goodsClassify.setMerchantId(merchantId);
        GoodsClassify classify = (GoodsClassify)this.goodsClassifyService.add((Serializable)goodsClassify);
        return RestResult.success();
    }

    @PutMapping
    public RestResult updateGoodsClassify(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody GoodsClassify goodsClassify) {
        goodsClassify.setMerchantId(merchantId);
        int result = this.goodsClassifyService.update((Serializable)goodsClassify);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }

    @DeleteMapping(value={"{id}"})
    public RestResult deleteGoodsClassify(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        GoodsClassify goodsClassify = new GoodsClassify();
        goodsClassify.setId(id);
        int result = this.goodsClassifyService.delete(merchantId, (Serializable)goodsClassify);
        return result > 0 ? RestResult.success() : RestResult.fail();
    }
}

