/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.security.seller;

import com.enation.app.javashop.client.member.ShopRoleClient;
import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.context.user.UserContext;
import com.enation.app.javashop.model.base.CachePrefix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

public class SellerSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private ShopRoleClient shopRoleClient;
    private Cache cache;

    public SellerSecurityMetadataSource(ShopRoleClient shopRoleClient, Cache cache) {
        this.shopRoleClient = shopRoleClient;
        this.cache = cache;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        FilterInvocation fi = (FilterInvocation)object;
        String url = fi.getRequestUrl();
        return this.buildAttributes(url);
    }

    private Collection<ConfigAttribute> buildAttributes(String url) {
        ArrayList<String> roleList = new ArrayList<String>();
        if (UserContext.getSeller() != null) {
            Map roleMap = (Map)this.cache.get((Object)(CachePrefix.SHOP_URL_ROLE.getPrefix() + UserContext.getSeller().getSellerId()));
            if (roleMap == null) {
                roleMap = this.shopRoleClient.getRoleMap(UserContext.getSeller().getSellerId());
            }
            if (roleMap != null || roleMap.size() > 0) {
                for (String role : roleMap.keySet()) {
                    List urlList = (List)roleMap.get(role);
                    if (!this.matchUrl(urlList, url)) continue;
                    roleList.add("ROLE_SELLER_" + role);
                }
            }
        }
        if (roleList.isEmpty()) {
            return SecurityConfig.createList((String[])new String[]{"ROLE_SELLER_SUPER_SELLER"});
        }
        return SecurityConfig.createList((String[])roleList.toArray(new String[roleList.size()]));
    }

    private boolean matchUrl(List<String> expressionList, String url) {
        for (String expression : expressionList) {
            boolean isMatch = Pattern.matches(expression, url);
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }
}

