/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.security.seller;

import com.enation.app.javashop.client.member.ShopRoleClient;
import com.enation.app.javashop.core.security.seller.SellerAccessDecisionManager;
import com.enation.app.javashop.core.security.seller.SellerAuthenticationService;
import com.enation.app.javashop.core.security.seller.SellerSecurityMetadataSource;
import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.security.TokenAuthenticationFilter;
import com.enation.app.javashop.framework.security.impl.AbstractAuthenticationService;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@Order(value=2)
public class SellerSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AccessDeniedHandler accessDeniedHandler;
    @Autowired
    private AuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    private ShopRoleClient shopRoleClient;
    @Autowired
    private Cache cache;
    @Autowired
    private SellerAuthenticationService sellerAuthenticationService;

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).antMatcher("/seller/**").sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().accessDeniedHandler(this.accessDeniedHandler).authenticationEntryPoint(this.authenticationEntryPoint).and()).authorizeRequests().anyRequest()).authenticated().withObjectPostProcessor((ObjectPostProcessor)new ObjectPostProcessor<FilterSecurityInterceptor>(){

            public <O extends FilterSecurityInterceptor> O postProcess(O fsi) {
                fsi.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)new SellerSecurityMetadataSource(SellerSecurityConfig.this.shopRoleClient, SellerSecurityConfig.this.cache));
                fsi.setAccessDecisionManager((AccessDecisionManager)new SellerAccessDecisionManager());
                return fsi;
            }
        }).and()).addFilterBefore((Filter)new TokenAuthenticationFilter((AbstractAuthenticationService)this.sellerAuthenticationService), UsernamePasswordAuthenticationFilter.class);
        http.headers().cacheControl().and().contentSecurityPolicy("script-src 'self'");
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        source.registerCorsConfiguration("/**", config);
        return source;
    }
}

