/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.security.buyer;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger.web.ApiResourceController;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.web.Swagger2Controller;

@Controller
@ApiIgnore
@RequestMapping(value={"${spring.application.name}"})
public class SwaggerResourceController
implements InitializingBean {
    @Autowired
    private ApiResourceController apiResourceController;
    @Autowired
    private Environment environment;
    @Autowired
    private DocumentationCache documentationCache;
    @Autowired
    private ServiceModelToSwagger2Mapper mapper;
    @Autowired
    private JsonSerializer jsonSerializer;
    private Swagger2Controller swagger2Controller;

    public void afterPropertiesSet() {
        this.swagger2Controller = new Swagger2Controller(this.environment, this.documentationCache, this.mapper, this.jsonSerializer);
    }

    @RequestMapping(value={"/swagger-resources/configuration/security"})
    @ResponseBody
    public ResponseEntity<SecurityConfiguration> securityConfiguration() {
        return this.apiResourceController.securityConfiguration();
    }

    @RequestMapping(value={"/swagger-resources/configuration/ui"})
    @ResponseBody
    public ResponseEntity<UiConfiguration> uiConfiguration() {
        return this.apiResourceController.uiConfiguration();
    }

    @RequestMapping(value={"/swagger-resources"})
    @ResponseBody
    public ResponseEntity<List<SwaggerResource>> swaggerResources() {
        return this.apiResourceController.swaggerResources();
    }

    @RequestMapping(value={"/v2/api-docs"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @ResponseBody
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        return this.swagger2Controller.getDocumentation(swaggerGroup, servletRequest);
    }
}

