/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bizvane.members.feign.model.bo.MbrIntegralAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrIntegralSubRequestParam;
import com.bizvane.members.feign.model.vo.MbrMembersDetailVO;
import com.bizvane.members.feign.service.IntegralFeign;
import com.bizvane.members.feign.service.MbrMemberFeign;
import com.bizvane.task.center.api.service.common.enums.BatchTaskTypeEnum;
import com.bizvane.task.center.api.service.model.vo.MbrIntegralBatchTaskExcelVO;
import com.bizvane.task.center.domain.model.dto.MbrIntegralBatchTaskDetailListRequestDTO;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.model.entity.MbrIntegralBatchDetailPO;
import com.bizvane.task.center.domain.model.entity.MbrIntegralBatchPO;
import com.bizvane.task.center.domain.service.IBatchTaskService;
import com.bizvane.task.center.domain.service.IMbrIntegralBatchDetailService;
import com.bizvane.task.center.domain.service.IMbrIntegralBatchService;
import com.bizvane.task.center.feign.model.bo.BatchTaskAddRequestParam;
import com.bizvane.task.center.feign.model.bo.MbrIntegralAddBatchTaskDetailRequestParam;
import com.bizvane.task.center.feign.model.bo.MbrIntegralAddBatchTaskRequestParam;
import com.bizvane.task.center.feign.model.bo.MbrIntegralBatchTaskListRequestParam;
import com.bizvane.task.center.feign.model.vo.MbrIntegralBatchVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.excel.ExcelImportUtil;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MbrIntegralBatchService {
    private static final Logger log = LoggerFactory.getLogger(MbrIntegralBatchService.class);
    @Autowired
    private IMbrIntegralBatchService iMbrIntegralBatchService;
    @Autowired
    private IMbrIntegralBatchDetailService iMbrIntegralBatchDetailService;
    @Autowired
    private IBatchTaskService iBatchTaskService;
    @Autowired
    private MbrMemberFeign mbrMemberFeign;
    @Autowired
    private IntegralFeign integralFeign;
    @Lazy
    @Autowired
    private MbrIntegralBatchService mbrIntegralBatchService;

    @Transactional
    public ResponseData<String> addBatchTask(MbrIntegralAddBatchTaskRequestParam param) {
        BatchTaskAddRequestParam taskParam = BatchTaskAddRequestParam.builder().taskName(param.getTaskName()).taskType(BatchTaskTypeEnum.CHANGE_INTEGRAL.getType()).param(param.getUrl()).userCode(param.getUserCode()).userName(param.getUserName()).build();
        String batchTaskCode = this.iBatchTaskService.add(taskParam);
        String mbrIntegralBatchCode = this.iMbrIntegralBatchService.add(param);
        if (StringUtils.isEmpty((CharSequence)mbrIntegralBatchCode) && StringUtils.isEmpty((CharSequence)batchTaskCode)) {
            log.error("\u65b0\u589e\u4efb\u52a1\u8bb0\u5f55\u5931\u8d25");
            throw new BizException(-1, "\u521b\u5efa\u4efb\u52a1\u5931\u8d25");
        }
        return new ResponseData();
    }

    public PageInfo<MbrIntegralBatchVO> list(MbrIntegralBatchTaskListRequestParam param) {
        IPage page = this.iMbrIntegralBatchService.list(param);
        ArrayList<MbrIntegralBatchVO> list = new ArrayList<MbrIntegralBatchVO>();
        for (MbrIntegralBatchPO po : page.getRecords()) {
            MbrIntegralBatchVO vo = new MbrIntegralBatchVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            list.add(vo);
        }
        return new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), list);
    }

    @Transactional
    public ResponseData<String> addBatchTaskDetail(MbrIntegralAddBatchTaskDetailRequestParam param) {
        log.info("MbrIntegralService.addBatchTaskDetail:{}", (Object)JacksonUtil.bean2Json((Object)param));
        String mbrIntegralBatchCodeDetail = this.iMbrIntegralBatchDetailService.add(param);
        if (StringUtils.isNotEmpty((CharSequence)mbrIntegralBatchCodeDetail)) {
            log.error("\u65b0\u589e\u8bb0\u5f55\u5931\u8d25");
            return new ResponseData(-1, "\u65b0\u589e\u8bb0\u5f55\u5931\u8d25");
        }
        return new ResponseData((Object)mbrIntegralBatchCodeDetail);
    }

    public void detailExecuting(BatchTaskPO batchTaskPO) {
        long minId = 0L;
        while (true) {
            MbrIntegralBatchTaskDetailListRequestDTO dto;
            List list;
            if ((list = this.iMbrIntegralBatchDetailService.list(dto = MbrIntegralBatchTaskDetailListRequestDTO.builder().mbrIntegralBatchCode(batchTaskPO.getBatchTaskCode()).status(Integer.valueOf(0)).minId(minId).pageNum(1).pageSize(1000).build()).getRecords()).isEmpty()) {
                this.iMbrIntegralBatchService.updateStatus(batchTaskPO.getBatchTaskCode(), Integer.valueOf(1), null, null);
                return;
            }
            for (MbrIntegralBatchDetailPO detailPO : list) {
                this.mbrIntegralBatchService.extracted(batchTaskPO, detailPO);
            }
            minId = ((MbrIntegralBatchDetailPO)list.get(list.size() - 1)).getId();
        }
    }

    @Transactional
    public void extracted(BatchTaskPO batchTaskPO, MbrIntegralBatchDetailPO detailPO) {
        MbrIntegralSubRequestParam integralAddRequestParam;
        MbrMembersDetailVO mbrMembersDetailVO = (MbrMembersDetailVO)this.mbrMemberFeign.detail(detailPO.getCardNo()).getData();
        if (mbrMembersDetailVO == null) {
            log.error("\u4f1a\u5458\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7:{}", (Object)detailPO.getCardNo());
            detailPO.setStatus(Integer.valueOf(2));
            detailPO.setFailDetail("\u4f1a\u5458\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7");
            this.iMbrIntegralBatchDetailService.updateById((Object)detailPO);
            return;
        }
        Integer changeIntegral = detailPO.getChangeIntegral();
        ResponseData changeResponse = null;
        if (changeIntegral < 0) {
            integralAddRequestParam = MbrIntegralAddRequestParam.builder().mbrMembersCode(mbrMembersDetailVO.getMbrMembersCode()).changeBills(detailPO.getMbrIntegralBatchCodeDetail()).changeSource(batchTaskPO.getBatchTaskCode()).changeDetails(batchTaskPO.getTaskName()).changeIntegral(detailPO.getChangeIntegral()).changeDate(LocalDateTime.now()).businessWay("4").airportNo(detailPO.getAirportNo()).industryNo(detailPO.getIndustryNo()).merchantNo(detailPO.getMerchantNo()).expiredTime(LocalDateTime.now().plusDays(detailPO.getIntegralValidDay().intValue()).toLocalDate().atTime(LocalTime.MAX)).userCode(batchTaskPO.getCreateUserCode()).userName(batchTaskPO.getCreateUserName()).build();
            changeResponse = this.integralFeign.add((MbrIntegralAddRequestParam)integralAddRequestParam);
        } else {
            integralAddRequestParam = MbrIntegralSubRequestParam.builder().mbrMembersCode(mbrMembersDetailVO.getMbrMembersCode()).changeBills(detailPO.getMbrIntegralBatchCodeDetail()).changeSource(batchTaskPO.getBatchTaskCode()).changeDetails(batchTaskPO.getTaskName()).changeIntegral(detailPO.getChangeIntegral()).changeDate(LocalDateTime.now()).businessWay("4").airportNo(detailPO.getAirportNo()).industryNo(detailPO.getIndustryNo()).merchantNo(detailPO.getMerchantNo()).userCode(batchTaskPO.getCreateUserCode()).userName(batchTaskPO.getCreateUserName()).build();
            changeResponse = this.integralFeign.sub(integralAddRequestParam);
        }
        boolean changeResult = SysResponseEnum.SUCCESS.getCode() == changeResponse.getCode();
        boolean updateStatus = this.iMbrIntegralBatchDetailService.updateStatus(detailPO.getMbrIntegralBatchCodeDetail(), Integer.valueOf(changeResult ? 1 : 2), changeResult ? null : changeResponse.getMessage());
        if (!updateStatus) {
            log.error("\u66f4\u65b0\u4efb\u52a1\u660e\u7ec6\u72b6\u6001\u5931\u8d25:{}", (Object)detailPO.getMbrIntegralBatchCodeDetail());
            throw new BizException(-1, "\u66f4\u65b0\u4efb\u52a1\u660e\u7ec6\u72b6\u6001\u5931\u8d25");
        }
        this.iMbrIntegralBatchService.updateStatus(batchTaskPO.getBatchTaskCode(), Integer.valueOf(1), changeResult ? Integer.valueOf(1) : null, changeResult ? null : Integer.valueOf(1));
    }

    public void detailGenerating(BatchTaskPO batchTaskPO) {
        List list = (List)this.getImportData(batchTaskPO.getParam()).getData();
        for (MbrIntegralBatchTaskExcelVO excelVO : list) {
            String cardNo = excelVO.getCardNo();
            MbrIntegralBatchDetailPO detailPO = this.iMbrIntegralBatchDetailService.detail(batchTaskPO.getBatchTaskCode(), cardNo);
            if (detailPO != null) {
                log.info("\u4efb\u52a1\u660e\u7ec6\u5df2\u751f\u6210\uff0c\u8df3\u8fc7:{}", (Object)cardNo);
                continue;
            }
            MbrIntegralAddBatchTaskDetailRequestParam param = MbrIntegralAddBatchTaskDetailRequestParam.builder().mbrIntegralBatchCode(batchTaskPO.getBatchTaskCode()).cardNo(cardNo).changeIntegral(excelVO.getChangeIntegral()).integralValidDay(excelVO.getIntegralValidDay()).airportNo(excelVO.getAirportNo()).industryNo(excelVO.getIndustryNo()).merchantNo(excelVO.getMerchantNo()).userCode(batchTaskPO.getCreateUserCode()).userName(batchTaskPO.getCreateUserName()).build();
            this.addBatchTaskDetail(param);
        }
    }

    public ResponseData<List<MbrIntegralBatchTaskExcelVO>> getImportData(String excelUrl) {
        ExcelImportUtil excelImportUtil = new ExcelImportUtil();
        ArrayList<MbrIntegralBatchTaskExcelVO> importList = new ArrayList<MbrIntegralBatchTaskExcelVO>();
        try {
            List excelData = excelImportUtil.parseExcel(excelUrl);
            for (List row : excelData) {
                MbrIntegralBatchTaskExcelVO vo = new MbrIntegralBatchTaskExcelVO();
                vo.setCardNo((String)row.get(0));
                vo.setChangeIntegral(Integer.valueOf((String)row.get(1)));
                vo.setIntegralValidDay(Integer.valueOf((String)row.get(2)));
                vo.setAirportNo((String)row.get(3));
                vo.setIndustryNo((String)row.get(4));
                vo.setMerchantNo((String)row.get(5));
                importList.add(vo);
            }
        }
        catch (IOException e) {
            log.error("\u89e3\u6790excel\u62a5\u9519:", (Throwable)e);
        }
        return new ResponseData(importList);
    }
}

