/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.task.center.domain.config.BusinessNoUtils;
import com.bizvane.task.center.domain.config.RandomUtils;
import com.bizvane.task.center.domain.model.dto.DorisCommonExportResultBO;
import com.bizvane.task.center.domain.model.entity.SysTaskPO;
import com.bizvane.task.center.domain.model.entity.SysTemplateSqlPO;
import com.bizvane.task.center.domain.service.ICosFileOperationService;
import com.bizvane.task.center.domain.service.IExecuteExportService;
import com.bizvane.task.center.domain.service.IGetBuildExportSqlService;
import com.bizvane.task.center.domain.service.ISysTaskService;
import com.bizvane.task.center.domain.service.ISysTemplateSqlService;
import com.bizvane.task.center.feign.model.bo.DataExportParam;
import com.bizvane.task.center.feign.model.bo.ExportTaskListParam;
import com.bizvane.task.center.feign.model.vo.ExportTaskListVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class DataExportService {
    private static final Logger log = LoggerFactory.getLogger(DataExportService.class);
    @Autowired
    private IGetBuildExportSqlService iGetBuildExportSqlService;
    @Autowired
    private ISysTemplateSqlService iSysTemplateSqlService;
    @Autowired
    private ISysTaskService iSysTaskService;
    @Autowired
    private IExecuteExportService iExecuteExportService;
    @Autowired
    private ICosFileOperationService iCosFileOperationService;

    public void dataExport(@RequestBody DataExportParam param) throws SQLException {
        log.info("dataExport\uff1a{}", (Object)param);
        List resultList = null;
        String taskCode = BusinessNoUtils.getSystemNo();
        SysTaskPO updateSysTaskPO = new SysTaskPO();
        SysTaskPO insertSysTaskPO = new SysTaskPO();
        updateSysTaskPO.setTaskCode(taskCode);
        insertSysTaskPO.setTaskCode(taskCode);
        String businessCode = param.getBusinessCode();
        String selectId = param.getQueryId();
        if (businessCode == null || selectId == null) {
            log.error("\u4e1a\u52a1code\u6216\u67e5\u8be2ID\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u4e1a\u52a1code\u6216\u67e5\u8be2ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject dataJson = JSONObject.parseObject((String)param.getDataJson());
        if (dataJson == null) {
            log.error("\u89e3\u6790JSON\u6570\u636e\u5931\u8d25");
            throw new IllegalArgumentException("\u89e3\u6790JSON\u6570\u636e\u5931\u8d25");
        }
        SysTemplateSqlPO sysTemplateSqlPO = this.iSysTemplateSqlService.getTemplateXml(businessCode);
        if (sysTemplateSqlPO == null) {
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u6a21\u677f");
            throw new SQLException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u6a21\u677f");
        }
        String businessName = sysTemplateSqlPO.getBusinessName();
        insertSysTaskPO.setTaskName(businessName);
        insertSysTaskPO.setTaskType(Integer.valueOf(2));
        insertSysTaskPO.setBusinessCode(businessCode);
        insertSysTaskPO.setQueryId(selectId);
        insertSysTaskPO.setStatus(Integer.valueOf(1));
        insertSysTaskPO.setValid(Boolean.valueOf(true));
        insertSysTaskPO.setCreateUserCode(param.getCreateUseCode());
        insertSysTaskPO.setCreateUserName(param.getCreateUseName());
        this.iSysTaskService.insertTask(insertSysTaskPO);
        String sql = this.iGetBuildExportSqlService.buildSelectSql(sysTemplateSqlPO.getXml(), selectId, dataJson);
        if (sql == null || sql.trim().isEmpty()) {
            updateSysTaskPO.setFailureReason("\u6784\u5efaSQL\u8bed\u53e5\u5931\u8d25");
            this.iSysTaskService.updateTaskStatus(0, updateSysTaskPO);
            log.error("\u6784\u5efaSQL\u8bed\u53e5\u5931\u8d25");
            throw new SQLException("\u6784\u5efaSQL\u8bed\u53e5\u5931\u8d25");
        }
        log.info("\u67e5\u8be2sql\uff1a{}", (Object)sql);
        String filePath = this.iGetBuildExportSqlService.getExportFilePath(businessCode, businessName);
        log.info("\u5bfc\u51fa\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)filePath);
        String exportSql = this.iGetBuildExportSqlService.buildExportSql(businessCode, businessName, sql, filePath);
        if (exportSql == null || exportSql.trim().isEmpty()) {
            updateSysTaskPO.setFailureReason("\u6784\u5efa\u5bfc\u51fa\u8bed\u53e5\u5931\u8d25");
            this.iSysTaskService.updateTaskStatus(0, updateSysTaskPO);
            log.error("\u6784\u5efa\u5bfc\u51faSQL\u8bed\u53e5\u5931\u8d25");
            throw new SQLException("\u6784\u5efa\u5bfc\u51faSQL\u8bed\u53e5\u5931\u8d25");
        }
        try {
            updateSysTaskPO.setProgress(Integer.valueOf(RandomUtils.generateRandomNumber((int)2)));
            this.iSysTaskService.updateTaskStatus(2, updateSysTaskPO);
            resultList = this.iExecuteExportService.execute(exportSql, taskCode);
            if (resultList == null || resultList.isEmpty()) {
                log.error("\u5bfc\u51fa\u7ed3\u679c\u4e3a\u7a7a");
                updateSysTaskPO.setRemark("\u5bfc\u51fa\u7ed3\u679c\u4e3a\u7a7a");
                this.iSysTaskService.updateTaskStatus(3, updateSysTaskPO);
                return;
            }
            long totalRows = resultList.stream().mapToLong(DorisCommonExportResultBO::getTotalRows).sum();
            long fileSize = resultList.stream().mapToLong(DorisCommonExportResultBO::getFileSize).sum();
            int fileNumber = resultList.stream().mapToInt(DorisCommonExportResultBO::getFileNumber).sum();
            String fileUrl = this.iCosFileOperationService.fetchCsvConvertXlsxZipUploadCos(filePath);
            updateSysTaskPO.setTotalRows(Long.valueOf(totalRows));
            updateSysTaskPO.setFileNumber(Integer.valueOf(fileNumber));
            updateSysTaskPO.setFileSize(Long.valueOf(fileSize));
            updateSysTaskPO.setFileUrl(fileUrl);
            this.iSysTaskService.updateTaskStatus(3, updateSysTaskPO);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u6267\u884c\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            updateSysTaskPO.setFailureReason(e.getMessage());
            this.iSysTaskService.updateTaskStatus(0, updateSysTaskPO);
        }
    }

    public ResponseData<List<ExportTaskListVO>> getExportTaskList(@RequestBody ExportTaskListParam param) {
        List sysTaskPOList = this.iSysTaskService.getTaskList(param);
        ArrayList<ExportTaskListVO> voList = new ArrayList<ExportTaskListVO>();
        for (SysTaskPO po : sysTaskPOList) {
            ExportTaskListVO vo = new ExportTaskListVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            voList.add(vo);
        }
        return new ResponseData(voList);
    }
}

