/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.model.entity.CouponManualPO;
import com.bizvane.task.center.domain.service.ICouponManualCouponService;
import com.bizvane.task.center.domain.service.ICouponManualService;
import com.bizvane.task.center.feign.model.bo.CouponManualAddRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualCouponAddRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualListRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualUpdateStatusRequestParam;
import com.bizvane.task.center.feign.model.vo.CouponManualVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponManualService {
    private static final Logger log = LoggerFactory.getLogger(CouponManualService.class);
    @Autowired
    private ICouponManualService iCouponManualService;
    @Autowired
    private ICouponManualCouponService iCouponManualCouponService;

    public ResponseData<String> add(CouponManualAddRequestParam param) {
        String couponManualCode = (String)this.iCouponManualService.add(param).getData();
        if (StringUtils.isEmpty((CharSequence)couponManualCode)) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u65b0\u589e\u5931\u8d25");
        }
        for (CouponManualAddRequestParam.CouponManualCouponDefBO bo : param.getCouponList()) {
            CouponManualCouponAddRequestParam couponAddRequestParam = new CouponManualCouponAddRequestParam();
            couponAddRequestParam.setCouponManualCode(couponManualCode);
            couponAddRequestParam.setCouponDefinitionCode(bo.getCouponDefinitionCode());
            couponAddRequestParam.setCouponDefinitionName(bo.getCouponDefinitionName());
            couponAddRequestParam.setUserCode(param.getUserCode());
            couponAddRequestParam.setUserName(param.getUserName());
            this.iCouponManualCouponService.add(couponAddRequestParam);
        }
        return new ResponseData((Object)couponManualCode);
    }

    public PageInfo<CouponManualVO> list(CouponManualListRequestParam param) {
        IPage page = this.iCouponManualService.list(param);
        ArrayList<CouponManualVO> list = new ArrayList<CouponManualVO>();
        for (CouponManualPO po : page.getRecords()) {
            CouponManualVO vo = new CouponManualVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            List couponPOList = this.iCouponManualCouponService.list(po.getCouponManualCode());
            List couponList = couponPOList.stream().map(po1 -> new CouponManualAddRequestParam.CouponManualCouponDefBO(po1.getCouponDefinitionCode(), po1.getCouponDefinitionName())).collect(Collectors.toList());
            vo.setCouponList(couponList);
            list.add(vo);
        }
        return new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), list);
    }

    public CouponManualVO detail(String couponManualCode) {
        CouponManualListRequestParam param = new CouponManualListRequestParam();
        param.setCouponManualCode(couponManualCode);
        PageInfo page = this.list(param);
        return (CouponManualVO)page.getList().get(0);
    }

    public boolean updateStatus(CouponManualUpdateStatusRequestParam param) {
        return this.iCouponManualService.updateStatus(param);
    }

    public boolean detailGenerating(BatchTaskPO batchTaskPO) {
        return true;
    }
}

