package com.bizvane.scrm.facade.service;

import com.bizvane.scrm.facade.base.ResponseBaisonData;
import com.bizvane.scrm.facade.models.RequestOutsideModel;
import com.bizvane.scrm.facade.models.request.IntegralModel;
import com.bizvane.scrm.facade.models.request.MemberQueryReqModel;
import com.bizvane.scrm.facade.models.request.MemberReqModel;
import com.bizvane.scrm.facade.models.request.MemberRespModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author kitandrew
 * @version 1.0.0
 * @ClassName MemberService.java
 * @Description 会员相关
 * @createTime 2020年02月05日 15:38:00
 */
public interface MemberService {

    /**
     * basion调用CRM开卡
     * @param requestVo
     * @return
     */
    @PostMapping("/member/openCard")
    ResponseBaisonData openCard(@RequestBody @Valid RequestOutsideModel<MemberReqModel> requestVo);

    /**
     * basion查询CRM会员
     * @param requestVo
     * @return
     */
    @PostMapping("/member/queryMemberInfo")
    ResponseBaisonData<MemberRespModel> queryMemberInfo(@RequestBody @Valid RequestOutsideModel<MemberQueryReqModel> requestVo);

    /**
     * basion调用CRM开卡
     * @param requestVo
     * @return
     */
    @PostMapping("/member/updateMemberInfo")
    ResponseBaisonData updateMemberInfo(@RequestBody @Valid RequestOutsideModel<MemberReqModel> requestVo);


    /**
     * basion调用CRM调整积分
     * @param requestVo
     * @return
     */
    @PostMapping("/member/integralChange")
    ResponseBaisonData integralChange(@RequestBody @Valid RequestOutsideModel<IntegralModel> requestVo);

}
