package com.bizvane.scrm.facade.rpc;

import com.bizvane.scrm.facade.base.ResponseBaisonData;
import com.bizvane.scrm.facade.models.RequestOutsideModel;
import com.bizvane.scrm.facade.models.request.OrderRequestModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 订单接口
 */
@FeignClient(value = "${feign.client.scrm.name}", path = "${feign.client.scrm.path}")
public interface OrderServiceRpc {

    @PostMapping("/scrm/order/insert")
    ResponseBaisonData insert(RequestOutsideModel<OrderRequestModel> orderRequestModel);
}
