package com.bizvane.scrm.facade.models.request;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@Valid
public class RecordPayDetail implements Serializable {

    //小票单号
    @NotBlank(message = "record_code不能为空")
    @JSONField(name ="record_code")
    private String orderNo;

    //结算代码 000,现金，001 银行卡,002 储值卡,003 VIP储值卡,004 礼券,005 VIP积分,096 订金付款,097 VIP变现,098 线上优惠,099 线上支付,JDCOUPON 京东优惠券,passport_yh Passport支付优惠,VIPCZK_JE VIP储值卡实付金额,VIPCZK_YH VIP储值卡优惠金额
    //支付类型/方式代码
    @JSONField(name ="pay_code")
    private String payTypeId;
    //对应name
    private String payTypeName;

    //支付使用的优惠券号
    @JSONField(name ="coupon_code")
    private BigDecimal couponCode;

    //实收金额	   支付金额
    @JSONField(name ="money")
    private BigDecimal payAmount;

    //使用积分
    @JSONField(name ="integral_used")
    private Integer integralUsed;



    /***********************目前没有下面场景*********************/

    //储值卡code
    @JSONField(name ="prepaid_code")
    private Integer prepaidCode;

    //0 不折让 ,1折让
    @JSONField(name ="equalize")
    private Integer equalize;
}
