package com.bizvane.scrm.facade.models.request;


import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MemberQueryReqModel {

    @ApiModelProperty(value = "唯一值/会员卡号/手机号 优先按照会员卡号，再按照手机号", name = "data")
    private String data;

    @ApiModelProperty(value = "会员来源(必填字段)", name = "source")
    @JSONField(name = "source")
    private String openCardScene;

    @ApiModelProperty(value = "店铺代码", name = "shop_code")
    @JSONField(name = "shop_code")
    private String openCardStoreCode;

    @ApiModelProperty(value = "是否是员工", name = "is_staff")
    private Integer is_staff;

    @ApiModelProperty(value = "品牌code", name = "brand_code")
    @JSONField(name = "brand_code")
    private String offlineBrandCode;
}
