package com.bizvane.scrm.facade.models.request;


import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 主订单信息
 */
@Data
@Valid
public class ConsumeModel implements Serializable {


    /**
     * 退单情况下，会生成一笔新的订单，新的订单号，原单号字段关联原始订单，标准金额和下单数据量为负数，其余正常
     * /


    /****************内部填充属性**************************/

    private String memberCode;
    private Long sysCompanyId;
    private Long brandId;
    //订单类型,1.商城订单,2.积分订单3.门店订单
    private Integer orderType;
    private String offlineCompanyCode;

    //实际下单时间 == 支付时间
    private String billTime;

    /*****************外部传入属性*************************/


    //订单来源 1:线下零售单,3：云仓订单，2：微商城
    @JSONField(name = "order_from")
    private Integer orderFrom;

    //订单号
    @NotBlank(message = "record_code不能为空")
    @JSONField(name = "record_code")
    private String orderNo;

    //品牌code
    @NotBlank(message = "brand_code不能为空")
    @JSONField(name = "brand_code")
    private String offlineBrandCode;


    @NotBlank(message = "vip_code不能为空")
    @JSONField(name = "vip_code")
    private String erpId;


    //原单单号	(退单场景下使用)
    @JSONField(name = "origin_record_code")
    private String originalOrderNo;

    //消费类型（0：消费；1：退货；2：额外退款）
    @JSONField(name = "consume_type")
    private int orderFlag;

    //下单时间
    @JSONField(name = "operate_time")
    private String placeOrderTime;

    //店铺code
    @JSONField(name = "shop_code")
    private String serviceStoreCode;

    //商品数
    @JSONField(name = "num")
    private Integer productCount;

    //标准金额   商品吊牌价x数量  确认百胜计算好传入的
    @JSONField(name = "standard_money")
    private BigDecimal commodityAmount;

    //支付金额  == 成交金额  ==  折扣价x数量  确认百胜计算好的，并且是支付金额
    @JSONField(name = "money")
    private BigDecimal payMoney;

    //抵现积分   == 使用积分
    @JSONField(name = "discount_integral")
    private Integer usedIntegral;

    //备注
    @JSONField(name = "remark")
    private String remark;

    //组织code
    @JSONField(name = "org_code")
    private String orgCode;


    /**************************接收但不作处理******************************/

    //折扣
    @JSONField(name = "discount")
    private Double discount;

    //积分
    @JSONField(name = "integral")
    private Integer integral;

    //兑换积分
    @JSONField(name = "exchange_integral")
    private Integer exchangeIntegral;

    //消费导购员代码逗号分割  导购codes  === 暂定存name
    @JSONField(name = "assistant_list_code")
    private String serviceGuideNames;

    //营业日期
    @JSONField(name = "open_time")
    public Date openTime;

    //抹零金额
    @JSONField(name = "cash_free_money")
    private BigDecimal cashFreeMoney;

    //收款金额
    @JSONField(name = "cash_money")
    private BigDecimal cashMoney;

    //找零金额
    @JSONField(name = "change_money")
    private BigDecimal changeMoney;

    //让利金额
    @JSONField(name = "discount_money")
    private BigDecimal discountMoney;

    //礼券金额
    @JSONField(name = "coupon_money")
    private BigDecimal couponMoney;

    //有效业绩金额
    @JSONField(name = "real_money")
    private BigDecimal realMoney;

}
