package com.bizvane.scrm.facade.models;


import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

//外层通用实体
@Data
@Slf4j
public class RequestOutsideModel<T> implements Serializable {


    private String method;
    private String key;
    private String time;
    @NotBlank(message = "sign不能为空")
    private String sign;
    // 企业编号
    private String cropCode;

    @Valid
    @NotNull
    private T params;
}
