package com.bizvane.scrm.facade.enums;

public enum OrderTypeEnum {

    ORDER_ONE(1, "商城订单"),
    ORDER_TWO(2, "积分订单"),
    ORDER_THREE(3, "门店订单");

    private Integer code;

    private String msg;

    OrderTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (OrderTypeEnum type : OrderTypeEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }
}
