package com.bizvane.scrm.facade.enums;

/**
 * 识别接口类型枚举类
 */
public enum  MethodEnum {

    ADD_ORDER(1, "add_consume"),
    get_VIP(2,"get_vip"),
    ADD_VIP(3,"add_vip"),
    UPDATE_VIP(4,"update_vip"),
    VIP_INTEGRAL(5,"sync_vip_integral_record");


    private Integer code;

    private String msg;

    MethodEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (MethodEnum type : MethodEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }
}
