package com.bizvane.scrm.facade.base;

import com.bizvane.utils.enumutils.SysResponseEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 *
 * @param <T>
 * baison 返回body
 */
@Data
@ToString
@EqualsAndHashCode
public class ResponseBaisonData<T> {

    private int status;
    private String message;
    private T data;


    public ResponseBaisonData(T data) {
        this.status = SysResponseEnum.SUCCESS.getCode();
        this.message = SysResponseEnum.SUCCESS.getMessage();
        this.data = data;
    }

    public ResponseBaisonData() {
        this.status = SysResponseEnum.SUCCESS.getCode();
        this.message = SysResponseEnum.SUCCESS.getMessage();
    }


    public ResponseBaisonData(int status, String message, T data) {
        this.status = SysResponseEnum.SUCCESS.getCode();
        this.message = SysResponseEnum.SUCCESS.getMessage();
        this.status = status;
        this.data = data;
        this.message = message;
    }

    public ResponseBaisonData(int status, T data) {
        this.status = SysResponseEnum.SUCCESS.getCode();
        this.message = SysResponseEnum.SUCCESS.getMessage();
        this.status = status;
        this.data = data;
    }

    public ResponseBaisonData(String message, T data) {
        this.status = SysResponseEnum.SUCCESS.getCode();
        this.message = SysResponseEnum.SUCCESS.getMessage();
        this.data = data;
        this.message = message;
    }
}
