package com.bizvane.rights.vo.parking.order;

import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.OptUserVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class RightsParkingOrderSaveRequestVO extends OptUserVO implements Serializable {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("渠道Code, 10=微信渠道, 20=线下渠道")
    private Integer channelCode;

    @ApiModelProperty("来源Code, 10=爱上启航小程序, 20=上海机场小程序, 30=浦东机场小程序, 40=缤纷品购小程序, 50=上海机场贵宾线上VIP小程序, 60=虹桥机场交通小程序, 70=浦东机场商业POS, 80=虹桥机场商业POS")
    private Integer sourceCode;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("停车记录编号")
    private String parkingRecordNo;

    @ApiModelProperty("所属航站楼")
    private String terminal;

    @ApiModelProperty("车牌号")
    private String carPlate;

    @ApiModelProperty("车牌颜色")
    private String carPlateColor;

    @ApiModelProperty("停车场名称")
    private String parkName;

    @ApiModelProperty("入口名称")
    private String entranceName;

    @ApiModelProperty("入口时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @DateTimeFormat(pattern = BusinessConst.YMDHMS)
    private LocalDateTime entranceTime;

    @ApiModelProperty("出口名称")
    private String exitName;

    @ApiModelProperty("出口时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @DateTimeFormat(pattern = BusinessConst.YMDHMS)
    private LocalDateTime exitTime;

    @ApiModelProperty("停车时长（分钟）")
    private Integer parkingTime;

    @ApiModelProperty("支付金额")
    private BigDecimal paidInAmount;

    @ApiModelProperty("支付类型, 1, 优惠券; 2, 银行卡; 3, 微信; 4, 支付宝; 5, 现金; 6, ETC; 7, 其他方式")
    private Integer payTypeId;

    @ApiModelProperty("支付类型名称")
    private String payTypeName;

    @ApiModelProperty("支付完成时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @DateTimeFormat(pattern = BusinessConst.YMDHMS)
    private LocalDateTime paymentEndTime;

    @ApiModelProperty("备注")
    private String remark;
}
