package com.bizvane.rights.feign.mobile;

import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitDetailRespVO;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitTypeRespVO;
import com.bizvane.rights.vo.staffbenefit.mobile.MobileStaffBenefitPageReqVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.rights.name}",path = "${feign.client.rights.path}/mobileStaffBenefit")
public interface MobileStaffBenefitFeign {

    @GetMapping("getStaffBenefitTypeList")
    ResponseData<List<QueryStaffBenefitTypeRespVO>> getStaffBenefitTypeList();

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryStaffBenefitDetailRespVO>> pageList(@RequestBody MobileStaffBenefitPageReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryStaffBenefitDetailRespVO> getDetail(@RequestParam("mktStaffBenefitCode") String mktStaffBenefitCode);
}
