package com.bizvane.rights.feign;

import com.bizvane.rights.vo.parking.barrierfree.RightsBarrierFreeParkingSaveRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 无障碍车位预约feign
 *
 * @author liuying
 */
@Api(value = "无障碍车位预约", tags = "无障碍车位预约")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/barrierFreeParking")
public interface BarrierFreeParkingFeign {

    @ApiOperation(value = "保存无障碍车位预约记录", notes = "保存无障碍车位预约记录", httpMethod = "POST")
    @PostMapping("addOrUpdate")
    ResponseData<Boolean> addOrUpdate(@RequestBody RightsBarrierFreeParkingSaveRequestVO requestVO);
}
