package com.bizvane.rights.vo.steward;

import com.auth0.jwt.internal.com.fasterxml.jackson.annotation.JsonFormat;
import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.OptStatusVO;
import com.bizvane.rights.vo.OptUserVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class StewardServiceReqRespVO extends OptUserVO {
    @ApiModelProperty("服务名字")
    private String name;

    @ApiModelProperty("机场管家服务code")
    private String stewardServiceCode;
    @ApiModelProperty("服务代码-用户自行输入编号")
    private String serviceNo;
    @ApiModelProperty("服务机场")
    private String airportCode;
    @ApiModelProperty("机场名字")
    private String airportName;
    @ApiModelProperty("服务类型:1-接机服务，2-送机服务，3-租车服务，4-其他")
    private Integer serviceType;

    @ApiModelProperty("主图")
    private String mainImageUrl;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("优惠价")
    private BigDecimal preferentialPrice;

    @ApiModelProperty("服务内容")
    private String content;

    @ApiModelProperty("是否含有车辆服务0否1是")
    private Integer carServer;

    @ApiModelProperty("1启用，2禁用")
    private Integer status;
    @ApiModelProperty("公共字段：创建人编码")
    private String createUserCode;

    private String createUserName;
    @ApiModelProperty("公共字段：新增时不需要")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;
    @ApiModelProperty("公共字段：新增时不需要")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;
    private String modifiedUserCode;
    private String modifiedUserName;

}
