package com.bizvane.rights.vo.steward;

import com.auth0.jwt.internal.com.fasterxml.jackson.annotation.JsonFormat;
import com.bizvane.rights.consts.BusinessConst;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Version;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class StewardServiceDescriptionMobileRespVo implements Serializable {


    @ApiModelProperty("取消时间（单位：小时，最小输入1最大24）")
    private Integer endCancelTime;

    @ApiModelProperty("服务介绍code")
    private String stewardServiceDescriptionCode;

    @ApiModelProperty("管家服务介绍")
    private String description;

    @ApiModelProperty("服务电话")
    private String telePhone;

    @ApiModelProperty("公共字段：创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("公共字段：创建人编码")
    private String createUserCode;

    private String createUserName;
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;

    private String modifiedUserCode;

    private String modifiedUserName;
}
