package com.bizvane.rights.vo.steward;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author liuying
 * @since 2024-12-09
 */
@Getter
@Setter
@ApiModel(value = "StewardOrderMobile响应对象", description = "")
public class StewardOrderMobileRespVO implements Serializable {
    @ApiModelProperty("机场管家订单code")
    private String stewardOrderCode;
    @ApiModelProperty("订单下对应的管家服务信息")
    List<StewardServiceOrderDetailMobileRespVO> services;
    @ApiModelProperty("订单二维码")
    private String orderQRCode;
    @ApiModelProperty("支付时间")
    private String paymentDate;
    @ApiModelProperty("完成时间")
    private String finishDate;
    @ApiModelProperty("下单时间")
    private LocalDateTime createDate;
    @ApiModelProperty("航班信息code")
    private String basicFlightCode;
    @ApiModelProperty("航班日期")
    private LocalDateTime flightScheduledDate;
    @ApiModelProperty("航班号")
    private String flightIdentity;
    @ApiModelProperty("航空公司名称")
    private String airlineCn;
    @ApiModelProperty("起飞机场")
    private String cnOriginAirport;
    @ApiModelProperty("到达机场")
    private String cnDestinationAirport;
    @ApiModelProperty("关联 t_basic_dict_general")
    private String orderServiceType;
    @ApiModelProperty("服务名称(接机服务，送机服务)")
    private String orderServiceName;
    @ApiModelProperty("预订价格")
    private BigDecimal reservePrice;
    @ApiModelProperty("使用优惠券code")
    private String couponCode;
    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmount;
    @ApiModelProperty("实付金额")
    private BigDecimal reallyPrice;
    @ApiModelProperty("预约人姓名")
    private String orderName;

    @ApiModelProperty("预约人电话")
    private String orderMobile;

    @ApiModelProperty("预约人电话加密")
    private String orderMobileEncrypt;

    @ApiModelProperty("预约省份")
    private String orderProvince;

    @ApiModelProperty("预约城市")
    private String orderCity;

    @ApiModelProperty("预约行政区")
    private String orderDistrict;

    @ApiModelProperty("预约地址")
    private String orderAddress;

    @ApiModelProperty("预约地址code")
    private String addressCode;

    @ApiModelProperty("订单状态 0: 待支付, 1：待确认, 5：已确认, 2：服务中, 3已完成, 4 已取消")
    private Integer status;

}
