package com.bizvane.rights.vo.steward;

import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author liuying
 * @since 2024-12-09
 */
@Data
@ApiModel(value = "StewardOrderMobile请求对象", description = "")
public class StewardOrderMobileReqVO implements Serializable {

    @ApiModelProperty("航班号")
    private String flightIdentity;

    @ApiModelProperty("航班日期")
    private String flightScheduledDate;

    @ApiModelProperty("所选择的管家服务编码,多个用逗号分隔")
    private String stewardServiceCode;

    @ApiModelProperty("订单编码,点立即支付才生成")
    private String stewardOrderCode;

    @ApiModelProperty("预订总价(原预订价格)")
    private BigDecimal reservePrice;

    @ApiModelProperty("更改订单状态")
    private Integer status;

    @ApiModelProperty("用户openid")
    private String mbrOpenid;

    @ApiModelProperty("航班信息表code")
    private String basicFlightCode;

    @ApiModelProperty("航空公司名称")
    private String airlineCn;

    @ApiModelProperty("起飞机场")
    private String cnOriginAirport;

    @ApiModelProperty("到达机场")
    private String cnDestinationAirport;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("实付金额")
    private BigDecimal reallyPrice;

    @ApiModelProperty("使用优惠券code")
    private String couponCode;

    @ApiModelProperty("下单时间")
    private LocalDateTime orderTime;

    @ApiModelProperty("预约人姓名")
    private String orderName;

    @ApiModelProperty("预约人电话")
    private String orderMobile;

    @ApiModelProperty("预约人电话加密")
    private String orderMobileEncrypt;

    @ApiModelProperty("预约省份")
    private String orderProvince;

    @ApiModelProperty("预约城市")
    private String orderCity;


    @ApiModelProperty("预约行政区")
    private String orderDistrict;

    @ApiModelProperty("预约地址")
    private String orderAddress;

    @ApiModelProperty("预约地址code")
    private String addressCode;


    @ApiModelProperty("包含额外服务费用 0:包含 1:不包含")
    private Integer additionalCost;

    @ApiModelProperty("额外服务名称 0:公里数超额车辆费 1:车辆额外过桥过路费")
    private Integer additionalServiceName;

    @ApiModelProperty("额外服务费用")
    private BigDecimal additionalServicePrice;
}
