package com.bizvane.rights.vo.steward;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(value = "confirmAdditionalCost请求体", description = "")
public class StewardOrderConfirmAdditionalCostMobileReqVo implements Serializable {


    @ApiModelProperty("订单状态 0: 待支付, 1：待确认, 5：已确认, 2：服务中, 3已完成, 4 已取消")
    private Integer status;

    @ApiModelProperty("预订人(会员表code)")
    private String mbrMembersCode;

    @ApiModelProperty("机场管家订单code")
    private String stewardOrderCode;

    @ApiModelProperty("机场管家服务code")
    private String stewardServiceCode;

    @ApiModelProperty("服务名字")
    private String name;


    @ApiModelProperty("用户自行输入编号")
    private String serviceNo;

    @ApiModelProperty("关联 t_basic_airport 中的 airport_code 字段")
    private String airportCode;

    @ApiModelProperty("关联 t_base_dict_general：1接机服务；2送机服务,type_code=steward_service")
    private Integer serviceType;

    @ApiModelProperty("主图")
    private String mainImageUrl;

    @ApiModelProperty("原价")
    private BigDecimal originalPrice;

    @ApiModelProperty("优惠价")
    private BigDecimal preferentialPrice;

    @ApiModelProperty("服务内容")
    private String content;

    @ApiModelProperty("包含额外服务费用 0:包含 1:不包含")
    private Integer additionalCost;

    @ApiModelProperty("额外服务名称 0:公里数超额车辆费 1:车辆额外过桥过路费")
    private Integer additionalServiceName;

    @ApiModelProperty("额外服务费用")
    private BigDecimal additionalServicePrice;


}
