package com.bizvane.rights.vo.special;

import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.OptUserVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RightsSpecialPassengerSaveRequestVO extends OptUserVO implements Serializable {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("预约记录单号")
    private String appointmentRecordNo;

    @ApiModelProperty("服务对象类型, 1=无陪年长旅客, 2=无障碍需求旅客, 3=孕妇旅客, 4=行动不便旅客, 5=无陪怀抱婴儿旅客")
    private Integer serviceTargetType;

    @ApiModelProperty("联系电话, 敏感信息SM4加密后传输")
    private String contactNumber;

    @ApiModelProperty("联系电话加密")
    private String contactNumberEncrypt;

    @ApiModelProperty("是否需要轮椅, true/false")
    private Boolean requiresWheelchair;

    @ApiModelProperty("旅客信息列表,jsonArray")
    private String passengerInfo;

    @ApiModelProperty("备注(接口保存)")
    private String remarks;

    @ApiModelProperty("预约时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @DateTimeFormat(pattern = BusinessConst.YMDHMS)
    private LocalDateTime appointmentTime;

    @ApiModelProperty("预约状态, 1=确认中,2=待使用,3=已完成,4=已取消")
    private Integer appointmentStatus;

    @ApiModelProperty("航班信息")
    private RightsSpecialPassengerFlightDetailVO flightInfo;
}
