package com.bizvane.rights.feign.mobile;

import com.bizvane.rights.vo.steward.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
@Api(value = "管家mobile记录", tags = "管家mobile记录")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/stewardMobile")
public interface StewardMobileFeign {

    @ApiOperation(value ="机场管家首页", notes = "机场管家首页", httpMethod = "POST")
    @PostMapping("/findStewardServiceDescription")
    public ResponseData<StewardServiceDescriptionMobileRespVo> findStewardServiceDescription();

    @ApiOperation(value ="根据航班号查询管家服务", notes = "根据航班号查询管家服务", httpMethod = "POST")
    @PostMapping("/findServiceByFlightIdentityAndDate")
    public ResponseData<List<StewardServiceMobileRespVO>> findServiceByFlightIdentityAndDate(@RequestBody StewardServiceMobileReqVO reqVO);

    @ApiOperation(value ="立即预约", notes = "立即预约", httpMethod = "POST")
    @PostMapping("/payForOrder")
    public ResponseData<StewardPaymentRespVO> payForOrder(@RequestBody StewardPayForOrderMobileReqVO stewardOrderMobileReqVO);

    @ApiOperation(value ="立即支付后根据订单编码查结果", notes = "立即支付后根据订单编码查结果", httpMethod = "POST")
    @PostMapping("/findOrderDetailByOrderCode")
    public ResponseData<StewardOrderMobileRespVO> findOrderDetailByOrderCode(@RequestBody StewardOrderDetailMobileReqVo stewardOrderMobileReqVO);

    @ApiOperation(value ="取消订单", notes = "取消订单", httpMethod = "POST")
    @PostMapping("/cancel")
    public ResponseData<Boolean> cancel(@RequestBody StewardOrderCancelReq reqVO);

    @ApiOperation(value ="确认额外服务费用", notes = "确认额外服务费用", httpMethod = "POST")
    @PostMapping("/confirmAdditionalCost")
    public ResponseData<Boolean> confirmAdditionalCost(@RequestBody StewardOrderConfirmAdditionalCostMobileReqVo stewardOrderMobileReqVO);

    @ApiOperation(value ="支付二维码", notes = "支付二维码", httpMethod = "POST")
    @PostMapping("/paymentOrCode")
    public ResponseData<String> paymentOrCode(@RequestBody StewardOrderPayReqVo stewardOrderVO);

    @ApiOperation(value ="管家订单", notes = "管家订单", httpMethod = "POST")
    @PostMapping("/findOrderList")
    public ResponseData<PageInfo<StewardOrderReqRespVO>> findOrderList(@RequestBody StewardOrderQueryMobileReqVo stewardOrderVO);

    @ApiOperation(value ="额外服务费用支付", notes = "额外服务费用支付", httpMethod = "POST")
    @PostMapping("/payAdditionalCost")
    public ResponseData<StewardPaymentRespVO> payAdditionalCost(@RequestBody StewardOrderMobileReqVO stewardOrderVO);


}
