package com.bizvane.platform.feign.feign.basic;


import com.bizvane.platform.feign.model.vo.TSysAccountRoleVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tSysAccountRole")
@Api(value = "账号角色RPC")
public interface SysAccountRoleRpcFeign {

    @RequestMapping(value = "/getAccountRoleList", method = RequestMethod.POST)
    @ApiOperation(value = "获取账号角色信息列表")
    ResponseData<List<TSysAccountRoleVo>> getAccountRoleList(@RequestBody TSysAccountRoleVo req);

}
