package com.bizvane.platform.feign.model.req;

import com.bizvane.platform.feign.model.req.base.BasePageReq;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@EqualsAndHashCode(callSuper = true)
@Data
public class TSysRolePageReq extends BasePageReq implements Serializable {

    @ApiModelProperty(value = "角色名称")
    private String name;

    @ApiModelProperty(value = "租户ID")
    @NotBlank(message = "租户ID不能为空")
    private String tenantId;

    @ApiModelProperty(value = "状态：0=禁用；1=启用")
    private Boolean status;
}
