package com.bizvane.platform.feign.feign.basic;


import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
@FeignClient(value="${feign.client.platform.name}",path="${feign.client.platform.path}/serialNumber")
@Api(value = "序列号",tags = {"序列号"})
public interface SerialNumberServiceFeign {

    @ApiOperation(value = "生成全局序列号",notes = "生成全局序列号",tags = {"生成全局序列号"},httpMethod = "POST")
    @RequestMapping(value="/generateId", method = RequestMethod.POST)
    ResponseData<Long> generateId();

    @ApiOperation(value = "生成自增序列号",notes = "生成自增序列号",tags = {"序列号"},httpMethod = "POST")
    @RequestMapping(value="/generateIncrId", method = RequestMethod.POST)
    ResponseData<Long> generateIncrId(@RequestParam("type") String type);
}
