package com.bizvane.platform.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 租户菜单表
 * </p>
 */
@Data
public class TBasicTenantMenuVO {

    @ApiModelProperty("租户ID")
    private String tenantId;

    @ApiModelProperty(value = "子菜单编码", required = true)
    private String menuCode;

    @ApiModelProperty(value = "显示顺序")
    private Integer sort;

    @ApiModelProperty(value = "显示状态", allowableValues = "0, 1", notes = "1表示显示，0表示隐藏", required = true)
    private Integer display;

    @ApiModelProperty(value = "顶级菜单code", required = true)
    private String topMenuCode;

    @ApiModelProperty(value = "子菜单名称", required = true)
    private String menuName;

    @ApiModelProperty(value = "按钮列表", notes = "与该菜单相关的按钮列表")
    private List<TSysMenuButtonVO> menuBtnList;

    @ApiModelProperty(value = "子菜单列表", notes = "该菜单下的子菜单列表")
    private List<TBasicTenantMenuVO> preMenuList;
}
