package com.bizvane.payment.feign.vo.req;

import com.bizvane.utils.requestinfo.BasePageReq;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDate;

@Data
public class IcbcPayFrozenRecordPullReqVO extends BasePageReq implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotBlank(message = "商户支付配置系统编号code不能为空")
    @ApiModelProperty("商户支付配置系统编号code")
    private String paymentMerchantConfigCode;

    @NotBlank(message = "查询方式不能为空")
    @ApiModelProperty("查询方式：1-订单查询，2-日期查询")
    private String queryType;

    @NotBlank(message = "动作标志不能为空")
    @ApiModelProperty("动作标志: 1-查询，2-上一页，3-下一页（兼容主机的分页查询）")
    private String initFlag;

    @NotBlank(message = "工行外部协议编号不能为空")
    @ApiModelProperty("工行外部协议编号")
    private String icbcOutAgreeNo;

    @ApiModelProperty("工行订单号, 查询方式为1-订单查询时必输（不存在翻页）；查询方式为2-商户交易日期查询，翻上一页时需上送上一页第一条记录的工行订单号，翻下一页时需上送当前页最后一条记录的工行订单号。")
    private String icbcOrderNo;

    @ApiModelProperty("工行订单子序号, 工行订单子序号, 查询方式为1-订单查询时必输，不存在则赋0")
    private String icbcOrderSubNo;

    @ApiModelProperty("工行交易日期开始时间, 格式：yyyy-MM-dd，查询方式为：1-订单查询时生效，不输入则查询全部")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate startIcbcTrxDate;

    @ApiModelProperty("工行交易日期结束时间, 格式：yyyy-MM-dd，查询方式为：1-订单查询时生效，不输入则查询全部")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate endIcbcTrxDate;
}
