package com.bizvane.payment.feign.api;

import com.bizvane.payment.feign.vo.req.AddOrUpdatePaymentMerchantConfigReqVO;
import com.bizvane.payment.feign.vo.req.PaymentMerchantConfigPageReqVO;
import com.bizvane.payment.feign.vo.resp.PaymentMerchantConfigBaseRespVO;
import com.bizvane.payment.feign.vo.resp.QueryPaymentMerchantConfigRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 商户支付配置 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-11-20
 */
@FeignClient(value = "${feign.client.payment.name}", path = "${feign.client.payment.path}/tPaymentMerchantConfig")
public interface TPaymentMerchantConfigFeign {

    /**
     * 添加或更新商户支付配置
     *
     * @param reqVO
     * @return
     */
    @PostMapping("/saveOrUpdate")
    ResponseData<QueryPaymentMerchantConfigRespVO> saveOrUpdate(@RequestBody AddOrUpdatePaymentMerchantConfigReqVO reqVO);

    /**
     * 获取商户支付配置详情
     *
     * @param paymentMerchantConfigCode
     * @return
     */
    @GetMapping("/getDetail")
    ResponseData<QueryPaymentMerchantConfigRespVO> getDetail(@RequestParam("paymentMerchantConfigCode") String paymentMerchantConfigCode);

    /**
     * 删除商户支付配置
     *
     * @param paymentMerchantConfigCode
     * @return
     */
    @PutMapping("/delete")
    ResponseData<String> delete(@RequestParam("paymentMerchantConfigCode") String paymentMerchantConfigCode);

    /**
     * 获取商户支付配置分页信息
     *
     * @param reqVO
     * @return
     */
    @PostMapping("/baseInfoPage")
    ResponseData<PageInfo<PaymentMerchantConfigBaseRespVO>> baseInfoPage(@RequestBody PaymentMerchantConfigPageReqVO reqVO);


}
