package com.bizvane.payment.feign.vo.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class PrepareOrderReqVO extends BaseMerchantVO {

    @ApiModelProperty(value = "外部支付交易号")
    private String outTradeNo;

    @ApiModelProperty(value = "用户openid")
    private String openid;

    @ApiModelProperty(value = "支付金额 单位元 保留两位小数")
    private BigDecimal amount;

    @ApiModelProperty(value = "支付场景")
    private String description;

    @ApiModelProperty(value = "附加数据，在查询API和支付通知中原样返回，可作为自定义参数使用，实际情况下只有支付完成状态才会返回该字段")
    private String attach;
}
