package com.bizvane.openapifacade.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 券信息vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年08月29日 11:43:00
 */
@Data
public class CouponVo implements Serializable {


    @io.swagger.annotations.ApiModelProperty(value = "券号", name = "couponCode", required = false, example = "")
    private String couponCode;

    @io.swagger.annotations.ApiModelProperty(value = "券名称", name = "couponName", required = false, example = "")
    private String couponName;

    @io.swagger.annotations.ApiModelProperty(value = "面额", name = "money", required = false, example = "")
    private BigDecimal money;

    @io.swagger.annotations.ApiModelProperty(value = "折扣", name = "discount", required = false, example = "")
    private BigDecimal discount;

    @io.swagger.annotations.ApiModelProperty(value = "券说明", name = "info", required = false, example = "")
    private String info;

    @io.swagger.annotations.ApiModelProperty(value = "有效期开始时间", name = "validDateStart", required = false, example = "")
    private Date validDateStart;

    @io.swagger.annotations.ApiModelProperty(value = "有效期结束时间", name = "validDateEnd", required = false, example = "")
    private Date validDateEnd;

    @io.swagger.annotations.ApiModelProperty(value = "优惠类型（1现金，2折扣，3兑换）", name = "preferentialType", required = false, example = "")
    private Byte preferentialType;

    @ApiModelProperty(value = "创建时间", name = "createDate")
    private Date createDate;

    @ApiModelProperty(value = "修改时间", name = "modifiedDate")
    private Date modifiedDate;

    @ApiModelProperty(value = "券是否隐藏 1是0否已隐藏仅代表不在会员中心显示，券状态未做修改", name = "isHide")
    private Integer isHide;

    @ApiModelProperty(value = "使用时间", name = "useTime")
    private Date useTime;

    @ApiModelProperty(value = "//5-线上绑定，10-同步中，11-同步失败，12-同步成功，20-未使用，25-已过期，30-已核销", name = "couponStatus")
    private Byte couponStatus;

}
