package com.bizvane.mktcenterservice.models.vo.mktp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author yuantq
 * @date 2023/6/26
 */
@Data
public class FissionActivityParamsVO {

    private Long sysCompanyId;

    private Long sysBrandId;

    private String activityCode;

    private String memberCode;

    private List<String> memberCodeList;

    //活动ID
    private Long mktpActivityId;

    //阶梯奖品主键ID
    private Long mktpActivityStepId;

    //活动奖励主键ID
    private Long mktpActivityAwardRecordId;

    //分享人记录主键ID
    private Long mktpActivityShareId;

    private Integer pageNumber = 1;

    private Integer pageSize = 20;

    //邀请记录表主键ID
    private Long mktpActivityInvitationRecordId;

    //活动类型
    private Integer activityType;

    @ApiModelProperty(name = "inviteeAddedStaffIdList", value = "被邀请人添加的员工ID list", example = "")
    private List<Long> inviteeAddedStaffIdList;

    @ApiModelProperty(name = "clientBaseInfoIdList", value = "群聊ID list", example = "")
    private List<Long> clientBaseInfoIdList;

    @ApiModelProperty(name = "inviteeExternalName", value = "好友名称", example = "")
    private String inviteeExternalName;

    @ApiModelProperty(name = "inviteeStatus", value = "被邀请人邀请状态 1-邀请成功，2-邀请失败", example = "")
    private Integer inviteeStatus;

    @ApiModelProperty(name = "sharePhone", value = "邀请人手机号", example = "")
    private String sharePhone;

}
